/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentSaveContext;
import ordermate.database.sales.SalesMod;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.usagelink.StockUsageOptionLink;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_option")
@AccessType(value="property")
public class SalesOption
extends SalesMod
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<InventoryOption> option;
    private int sequence;
    private Price cost;
    private transient SalesComponentSaveContext saveContext;

    protected void setOption(Reference<InventoryOption> option) {
        this.option = option;
    }

    public SalesOption() {
        this.option = this.createReference(SalesOption.Properties.OPTION);
    }

    SalesOption(SalesOption copy) {
        super(copy);
        this.option = this.createReference(SalesOption.Properties.OPTION);
        this.option.set(copy.getOption());
        this.sequence = copy.getSequence();
    }

    public SalesOption(SalesComponent comp, InventoryOption newOption) {
        this();
        if (newOption == null) {
            throw new IllegalArgumentException("Option should not be null");
        }
        this.setLabel(newOption.getLabel());
        this.setBackgroundColor(newOption.getBackgroundColor());
        this.setForegroundColor(newOption.getForegroundColor());
        this.setIcon(newOption.getIcon());
        this.setComponent(comp);
        this.setOption(newOption);
        this.setPrice(newOption.getPrice());
        this.setSequence(newOption.getSequence());
    }

    @Override
    public void saveChild() {
        if (!this.isPersistent()) {
            this.cost = this.calculateIngredientCost(this.saveContext);
        }
        PersistenceManager.saveChild(this);
    }

    protected Price calculateIngredientCost(SalesComponentSaveContext context) {
        if (this.getCustomStockCost() != null) {
            return this.getCustomStockCost();
        }
        StockArea area = context.decrementArea;
        if (area != null) {
            this.cost = this.getOption().getOnHandCost(area);
        } else if (StockControlProperty.getInstance().isStockControlEnabled()) {
            OrderMate.LOG.warn("Attempt to calculate option cost with null stock area");
        }
        return this.cost;
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public boolean isEquivalentTo(SalesOption other) {
        return this.getOption().equals(other.getOption());
    }

    private void setSequence(int newSequence) {
        this.sequence = newSequence;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_option")
    public InventoryOption getOption() {
        return this.option.get();
    }

    private void setOption(InventoryOption newOption) {
        this.option.set(newOption);
    }

    @Override
    @Transient
    public ModificationSize getModificationSize() {
        return ModificationSize.getDefaultSize();
    }

    @Override
    public void setModificationSize(ModificationSize ms) {
    }

    @Transient
    public List<StockUsageOptionLink> getStockUsage() {
        return this.getOption().getStockUsageOptions();
    }

    @Transient
    public Price getCustomStockCost() {
        return this.getOption().getCustomStockCost();
    }

    @Override
    public void prepareForSave(SaveContext localContext) {
        this.saveContext = (SalesComponentSaveContext)localContext;
    }

    @Transient
    public boolean isPrintable() {
        return this.getOption().getOptionGroup().isPrintable() && !this.getOption().isDefault();
    }

    @Column(name="cost")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getCost() {
        return this.cost;
    }

    protected void setCost(Price cost) {
        this.cost = cost;
    }

    @Override
    @Transient
    public Props getProperties() {
        return Properties;
    }

    public static class Props
    extends SalesMod.Props {
        public PropertiedObject.Property<InventoryOption> OPTION;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property COST;
    }
}

