/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.sales.SalesOption;

public class SalesOptionComparator
implements Comparator<SalesOption> {
    private List<InventoryOptionGroup> groups;

    public SalesOptionComparator(InventoryItemUnit yourUnit) {
        List<InventoryOptionGroupLink> links = yourUnit.getOptionGroupLinks();
        if (links.size() <= 1) {
            this.groups = null;
        } else {
            this.groups = new ArrayList<InventoryOptionGroup>();
            for (InventoryOptionGroupLink link : links) {
                this.groups.add(link.getOptionGroup());
            }
        }
    }

    @Override
    public int compare(SalesOption o1, SalesOption o2) {
        if (this.groups != null && !o1.getOption().getOptionGroup().equals(o2.getOption().getOptionGroup())) {
            return this.groups.indexOf(o1.getOption().getOptionGroup()) - this.groups.indexOf(o2.getOption().getOptionGroup());
        }
        return o1.getSequence() - o2.getSequence();
    }
}

