/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.sales.loyalty.RedeemingLoyaltyPointTransaction;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_price_adjustment_usage")
@AccessType(value="property")
public class SalesPriceAdjustmentUsage
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<SalesPriceAdjustment> salesPriceAdjustment;
    private Reference<SalesComponent> salesComponent;
    private Reference<User> user;
    private Reference<Terminal> terminal;
    private Date creationTime;
    private Price unitValue;
    private Price savedTotalValue;
    private PersistentWriteableList<RedeemingLoyaltyPointTransaction> loyaltyPointTransactions;

    public SalesPriceAdjustmentUsage() {
        this.salesPriceAdjustment = this.createReference(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT);
        this.salesComponent = this.createReference(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT);
        this.user = this.createReference(SalesPriceAdjustmentUsage.Properties.USER);
        this.terminal = this.createReference(SalesPriceAdjustmentUsage.Properties.TERMINAL);
        this.creationTime = new Date();
        this.unitValue = Price.ZERO;
        this.savedTotalValue = null;
        this.loyaltyPointTransactions = this.createWriteableList(SalesPriceAdjustmentUsage.Properties.LOYALTY_POINT_TRANSACTIONS);
    }

    public SalesPriceAdjustmentUsage(SalesComponent component, SalesPriceAdjustment adjustment, EventContext context) {
        this.salesPriceAdjustment = this.createReference(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT);
        this.salesComponent = this.createReference(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT);
        this.user = this.createReference(SalesPriceAdjustmentUsage.Properties.USER);
        this.terminal = this.createReference(SalesPriceAdjustmentUsage.Properties.TERMINAL);
        this.creationTime = new Date();
        this.unitValue = Price.ZERO;
        this.savedTotalValue = null;
        this.loyaltyPointTransactions = this.createWriteableList(SalesPriceAdjustmentUsage.Properties.LOYALTY_POINT_TRANSACTIONS);
        OrderMate.LOG.debug("Creating price adjustment usage for : " + component + " and " + adjustment);
        this.setComponent(component);
        this.setPriceAdjustment(adjustment);
        this.setUser(context.getUser());
        this.setTerminal(context.getTerminal());
    }

    private SalesPriceAdjustmentUsage(SalesPriceAdjustmentUsage toCopy) {
        this.salesPriceAdjustment = this.createReference(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT);
        this.salesComponent = this.createReference(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT);
        this.user = this.createReference(SalesPriceAdjustmentUsage.Properties.USER);
        this.terminal = this.createReference(SalesPriceAdjustmentUsage.Properties.TERMINAL);
        this.creationTime = new Date();
        this.unitValue = Price.ZERO;
        this.savedTotalValue = null;
        this.loyaltyPointTransactions = this.createWriteableList(SalesPriceAdjustmentUsage.Properties.LOYALTY_POINT_TRANSACTIONS);
        OrderMate.LOG.debug("Copying price adjustment usage for : " + toCopy.getSalesComponent() + " and " + toCopy.getSalesPriceAdjustment(), (Throwable)new Exception());
        this.setComponent(toCopy.getSalesComponent());
        this.setPriceAdjustment(toCopy.getSalesPriceAdjustment());
        this.setUser(toCopy.getUser());
        this.setTerminal(toCopy.getTerminal());
        this.unitValue = toCopy.getUnitValue() != null ? toCopy.getUnitValue() : Price.ZERO;
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_price_adjustment")
    public SalesPriceAdjustment getSalesPriceAdjustment() {
        return this.salesPriceAdjustment.get();
    }

    protected void setSalesPriceAdjustment(SalesPriceAdjustment adj) {
        this.salesPriceAdjustment.set(adj);
    }

    public void setPriceAdjustment(SalesPriceAdjustment adj) {
        if (this.getSalesPriceAdjustment() != null) {
            this.getSalesPriceAdjustment().removePriceAdjustmentUsage(this);
        }
        this.setSalesPriceAdjustment(adj);
        if (adj != null) {
            adj.addPriceAdjustmentUsage(this);
        } else if (this.getSalesComponent() != null) {
            this.getSalesComponent().removePriceAdjustmentUsage(this);
        }
    }

    @Column(name="unit_value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="1.0E-5")})
    public Price getUnitValue() {
        return this.unitValue;
    }

    public void setUnitValue(Price newUnitValue) {
        this.unitValue = new Price(newUnitValue.doubleValue(), 1.0E-5);
    }

    @Column(name="saved_total_value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getSavedTotalValue() {
        return this.savedTotalValue != null ? new Price(this.savedTotalValue, 1.0E-4) : this.getValue();
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_component")
    public SalesComponent getSalesComponent() {
        return this.salesComponent.get();
    }

    protected void setSalesComponent(SalesComponent component) {
        this.salesComponent.set(component);
    }

    public void setComponent(SalesComponent component) {
        if (this.getSalesComponent() != null) {
            this.getSalesComponent().removePriceAdjustmentUsage(this);
        }
        this.setSalesComponent(component);
        if (component == null) {
            if (this.getSalesPriceAdjustment() != null) {
                this.getSalesPriceAdjustment().removePriceAdjustmentUsage(this);
            }
            this.salesPriceAdjustment.set(null);
        }
    }

    @Transient
    public PriceAdjustmentLevel getLevel() {
        return this.getSalesPriceAdjustment().getLevel();
    }

    @Override
    public void saveChild() {
        if (!this.getSalesComponent().isPersistent()) {
            throw new IllegalStateException("Sales component should be persistent before calling saveChild");
        }
        if (!this.getSalesPriceAdjustment().isPersistent()) {
            throw new IllegalStateException("SalesPriceAdjustment should be persistent before calling saveChild");
        }
        if (this.unitValue.equals(Price.ZERO_DOLLAR)) {
            throw new IllegalStateException("Cannot save a price adjustment usage with zero unit value.");
        }
        this.savedTotalValue = this.getValue();
        PersistenceManager.saveChild(this);
        this.loyaltyPointTransactions.saveChild();
    }

    public void clearReferences() {
        LoyaltyPointAdministrator.getInstance().usageRemoved(this);
        if (this.getSalesPriceAdjustment() != null) {
            this.getSalesPriceAdjustment().removePriceAdjustmentUsage(this);
            this.setPriceAdjustment(null);
        }
        if (this.getSalesComponent() != null) {
            this.getSalesComponent().removePriceAdjustmentUsage(this);
            this.setComponent(null);
        }
    }

    @Override
    public void deleteChild() {
        this.clearReferences();
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Transient
    public Price getValue() {
        if (this.unitValue == null || this.getSalesComponent() == null || this.getSalesComponent().getSalesItem() == null) {
            return Price.ZERO;
        }
        return this.unitValue.multiply(this.getSalesComponent().getSalesItem().getQuantity());
    }

    public SalesPriceAdjustmentUsage copy() {
        return new SalesPriceAdjustmentUsage(this);
    }

    private void setUser(User theUser) {
        this.user.set(theUser);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    private void setTerminal(Terminal newTerminal) {
        this.terminal.set(newTerminal);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationTime() {
        return new Date(this.creationTime.getTime());
    }

    protected void setCreationTime(Date newCreationTime) {
        this.creationTime = newCreationTime;
    }

    protected void setSavedTotalValue(Price newSavedTotalValue) {
        this.savedTotalValue = newSavedTotalValue;
    }

    public void addLoyaltyPointTransaction(RedeemingLoyaltyPointTransaction txn) {
        if (txn != null && !this.loyaltyPointTransactions.contains(txn)) {
            this.loyaltyPointTransactions.add(txn);
        }
    }

    public void removeLoyaltyPointTransaction(RedeemingLoyaltyPointTransaction txn) {
        if (txn != null && this.loyaltyPointTransactions.contains(txn)) {
            this.loyaltyPointTransactions.remove(txn);
        }
    }

    protected void setLoyaltyPointTransactions(List<RedeemingLoyaltyPointTransaction> txns) {
        this.loyaltyPointTransactions = this.loyaltyPointTransactions.clone();
        this.loyaltyPointTransactions.set(txns);
    }

    @Transient
    public List<RedeemingLoyaltyPointTransaction> getLoyaltyPointTransactions() {
        return this.loyaltyPointTransactions.getUnmodifiable();
    }

    @Transient
    public RedeemingLoyaltyPointTransaction getActiveLoyaltyTransaction() {
        for (RedeemingLoyaltyPointTransaction txn : this.loyaltyPointTransactions) {
            if (!SystemState.ACTIVE_STATE.equals(txn.getSystemState())) continue;
            return txn;
        }
        return null;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SalesPriceAdjustment> SALES_PRICE_ADJUSTMENT;
        public PropertiedObject.Property<SalesComponent> SALES_COMPONENT;
        public PropertiedObject.Property<Price> UNIT_VALUE;
        public PropertiedObject.Property<Price> SAVED_TOTAL_VALUE;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property CREATION_TIME;
        public PropertiedObject.Property<RedeemingLoyaltyPointTransaction> LOYALTY_POINT_TRANSACTIONS;
        public PersistentObject.DerivedProperty<SalesPriceAdjustmentUsage> LEVEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesPriceAdjustmentUsage.class), "level");
    }
}

