/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.Modification;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesComponent;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="NON_STOCKED")
@AccessType(value="property")
public class SalesRemove
extends AbstractSalesRemove {
    public static final Props Properties = new Props();
    private Reference<InventoryRemove> inventoryRemove;

    public SalesRemove() {
        this.inventoryRemove = this.createReference(SalesRemove.Properties.INVENTORY_REMOVE);
    }

    SalesRemove(SalesRemove copy) {
        super(copy);
        this.inventoryRemove = this.createReference(SalesRemove.Properties.INVENTORY_REMOVE);
        this.inventoryRemove.set(copy.getInventoryRemove());
    }

    public SalesRemove(SalesComponent newComponent, InventoryRemove remove) {
        super(remove.getModificationSize());
        this.inventoryRemove = this.createReference(SalesRemove.Properties.INVENTORY_REMOVE);
        this.setLabel(remove.getLabel());
        this.setBackgroundColor(remove.getBackgroundColor());
        this.setForegroundColor(remove.getForegroundColor());
        this.setIcon(remove.getIcon());
        this.setComponent(newComponent);
        this.setInventoryRemove(remove);
        this.setPrice(remove.getPrice());
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_remove")
    public InventoryRemove getInventoryRemove() {
        return this.inventoryRemove.get();
    }

    private void setInventoryRemove(InventoryRemove remove) {
        this.inventoryRemove.set(remove);
    }

    @Override
    public boolean isEquivalentTo(Modification mod) {
        if (!(mod instanceof SalesRemove)) {
            return false;
        }
        SalesRemove remove = (SalesRemove)mod;
        return remove.getInventoryRemove().equals(this.getInventoryRemove()) && remove.getModificationSize().equals(this.getModificationSize());
    }

    @Override
    public boolean matches(InventoryRemovable removeable) {
        if (removeable instanceof InventoryRemove) {
            return ((InventoryRemove)removeable).equals(this.getInventoryRemove());
        }
        return false;
    }

    @Override
    public boolean matches(AbstractSalesRemove remove) {
        if (remove instanceof SalesRemove) {
            SalesRemove salesRemove = (SalesRemove)remove;
            return this.inventoryRemove.getID().equals(salesRemove.inventoryRemove.getID());
        }
        return false;
    }

    @Override
    public SalesRemove copy() {
        return new SalesRemove(this);
    }

    public static class Props
    extends AbstractSalesRemove.Props {
        public PropertiedObject.Property<InventoryRemove> INVENTORY_REMOVE;
    }
}

