/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesComponent;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockLink;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import org.hibernate.annotations.AccessType;
import stockmate.database.interfaces.stock.MeasureUnitI;

@Entity
@DiscriminatorValue(value="STOCKED")
@AccessType(value="property")
public class SalesRemoveStocked
extends AbstractSalesRemove {
    public static final Props Properties = new Props();
    private Quantity usageQty;
    private Reference<StockItem> stockItem;
    private String measureUnit;
    private double rawQtyAmount;
    private boolean isFixedUsageQty;

    @Deprecated
    public SalesRemoveStocked() {
        this.stockItem = this.createReference(SalesRemoveStocked.Properties.STOCK_ITEM);
        this.isFixedUsageQty = false;
    }

    protected SalesRemoveStocked(SalesRemoveStocked stocked) {
        super(stocked);
        this.stockItem = this.createReference(SalesRemoveStocked.Properties.STOCK_ITEM);
        this.isFixedUsageQty = false;
        this.setStockItem(stocked.getStockItem());
        this.setUsageQty(stocked.getUsageQty());
        this.setLabel(stocked.getLabel());
        this.setBackgroundColor(stocked.getBackgroundColor());
        this.setForegroundColor(stocked.getForegroundColor());
        this.setIcon(stocked.getIcon());
        this.setPrice(stocked.getPrice());
        this.setFixedQty(stocked.isFixedUsageQty);
    }

    public SalesRemoveStocked(SalesComponent comp, StockInventoryUsageLink ingredient) {
        this(comp, ingredient, ModificationSize.getDefaultSize());
    }

    public SalesRemoveStocked(SalesComponent comp, StockInventoryUsageLink ingredient, ModificationSize modSize) {
        this.stockItem = this.createReference(SalesRemoveStocked.Properties.STOCK_ITEM);
        this.isFixedUsageQty = false;
        this.setComponent(comp);
        this.setModificationSize(modSize);
        this.setStockItem(ingredient.getStockItem());
        this.setUsageQty(ingredient.getQuantity());
        if (ingredient.getStockItem().getShortName() != null) {
            this.setLabel(ingredient.getStockItem().getShortName());
        } else {
            this.setLabel(ingredient.getStockItem().getLabel());
        }
        this.setBackgroundColor(ingredient.getBackgroundColor());
        this.setForegroundColor(ingredient.getForegroundColor());
        this.setIcon(ingredient.getIcon());
        this.setPrice(ingredient.getRemovePrice());
        this.setFixedQty(ingredient.isFixedQuantity());
    }

    @Transient
    public Quantity getUsageQty() {
        if (this.usageQty == null && this.measureUnit != null) {
            this.usageQty = new Quantity((MeasureUnitI)MeasureUnitHelper.getMeasureUnit(this.measureUnit), this.rawQtyAmount);
        }
        return this.usageQty;
    }

    @Transient
    public Quantity getModifiedUsageQty() {
        if (this.getModificationSize().getMultiplier() > 1.0) {
            OrderMate.LOG.info("Attempt to use multiplier greater than 1 for stocked minus");
            return this.getUsageQty();
        }
        return this.getUsageQty().multiply(this.getModificationSize().getMultiplier());
    }

    @Transient
    public StockItem getStockItem() {
        return this.stockItem.get();
    }

    protected void setUsageQty(Quantity qty) {
        this.usageQty = qty;
        if (qty != null) {
            this.measureUnit = qty.getMeasureUnit().getName();
            this.rawQtyAmount = qty.getRawValue();
        } else {
            this.measureUnit = null;
            this.rawQtyAmount = 0.0;
        }
    }

    protected void setRawQtyAmount(double qty) {
        this.rawQtyAmount = qty;
    }

    @Column(name="raw_qty_amount")
    protected double getRawQtyAmount() {
        return this.rawQtyAmount;
    }

    protected void setMeasureUnit(String measureUnitName) {
        this.measureUnit = measureUnitName;
    }

    @Column(name="measure_unit")
    protected String getMeasureUnit() {
        return this.measureUnit;
    }

    protected void setStockItem(StockItem item) {
        if (item == null) {
            throw new IllegalArgumentException("Stock item should not be null");
        }
        this.stockItem.set(item);
    }

    @Override
    public boolean matches(InventoryRemovable removeable) {
        if (removeable instanceof StockLink) {
            StockLink ingredient = (StockLink)((Object)removeable);
            return this.getStockItem().equals(ingredient.getStockItem()) && this.getUsageQty().equals(ingredient.getQuantity());
        }
        return false;
    }

    @Override
    public boolean matches(AbstractSalesRemove remove) {
        if (remove instanceof SalesRemoveStocked) {
            SalesRemoveStocked stocked = (SalesRemoveStocked)remove;
            if (!this.stockItem.getID().equals(stocked.stockItem.getID())) {
                return false;
            }
            return this.getUsageQty().equals(stocked.getUsageQty());
        }
        return false;
    }

    @Override
    public SalesRemoveStocked copy() {
        return new SalesRemoveStocked(this);
    }

    @Override
    public void setPrice(Price thePrice) {
        super.setPrice(thePrice != null ? thePrice : Price.ZERO_DOLLAR);
    }

    @Transient
    public boolean isFixedQty() {
        return this.isFixedUsageQty;
    }

    public void setFixedQty(boolean isFixedQty) {
        this.isFixedUsageQty = isFixedQty;
    }

    public static class Props
    extends AbstractSalesRemove.Props {
        public PersistentObject.DerivedProperty<Quantity> USAGE_QTY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesRemoveStocked.class), "usageQty");
        public PropertiedObject.Property<StockItem> STOCK_ITEM;
        public PropertiedObject.Property MEASURE_UNIT;
        public PropertiedObject.Property RAW_QTY_AMOUNT;
    }
}

