/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.FilterItemGroup;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.sales.itemfilter.OrderableItemFilter;

public class SellableWrapperFactory {
    public List<Sellable> getSellables(ItemGroup group) {
        if (group instanceof FilterItemGroup) {
            return ((FilterItemGroup)group).getAllSellableItems();
        }
        ArrayList<Sellable> sellablesList = new ArrayList<Sellable>();
        List<SalesLineItem> orderables = ItemFilter.filterItems(group.getItems(), new OrderableItemFilter());
        for (SalesLineItem item : orderables) {
            sellablesList.add(this.wrapItem(item));
        }
        sellablesList.addAll(this.getWrappedVoucherTransactions(group));
        return sellablesList;
    }

    public List<Sellable> getUnPaidSellables(ItemGroup group) {
        ArrayList<Sellable> sellableList = new ArrayList<Sellable>(0);
        for (SalesLineItem salesLineItem : group.getItemHelper().getUnpaidItems()) {
            sellableList.add(this.wrapItem(salesLineItem));
        }
        if (group instanceof Account) {
            Account account = (Account)group;
            for (GiftVoucherTransaction txn : account.getActiveVoucherTxns()) {
                if (txn.hasPayments() || !txn.getAmount().greaterThan(Price.ZERO_DOLLAR)) continue;
                sellableList.add(this.wrapTxn(txn));
            }
        }
        return sellableList;
    }

    private List<Sellable> getWrappedVoucherTransactions(ItemGroup group) {
        ArrayList<Sellable> sellablesList = new ArrayList<Sellable>();
        if (group instanceof Account) {
            Account account = (Account)group;
            account.refreshVoucherTxns();
            for (GiftVoucherTransaction txn : account.getActiveVoucherTxns()) {
                if (txn.isRedeemReversal() || !txn.isTopup() && !txn.isTopupReversal()) continue;
                sellablesList.add(this.wrapTxn(txn));
            }
        }
        return sellablesList;
    }

    public SalesLineItemWrapper<SalesLineItem> wrapItem(SalesLineItem item) {
        return new SalesLineItemWrapper<SalesLineItem>(item);
    }

    public VoucherTransactionWrapper wrapTxn(GiftVoucherTransaction txn) {
        return new VoucherTransactionWrapper(txn);
    }

    public List<Sellable> getSellables(List objects) {
        ArrayList<Sellable> sellables = new ArrayList<Sellable>();
        for (Object object : objects) {
            if (object instanceof SalesLineItem) {
                sellables.add(this.wrapItem((SalesLineItem)object));
                continue;
            }
            if (!(object instanceof GiftVoucherTransaction)) continue;
            sellables.add(this.wrapTxn((GiftVoucherTransaction)object));
        }
        return sellables;
    }

    public List<Sellable> getSellables(List<SalesLineItem> salesItems, List<GiftVoucherTransaction> txns) {
        ArrayList<Sellable> sellables = new ArrayList<Sellable>(0);
        if (salesItems != null) {
            sellables.addAll(this.getSellables(salesItems));
        }
        if (txns != null) {
            sellables.addAll(this.getSellables(txns));
        }
        return sellables;
    }

    public <T> List getSellingObjectsAs(List<Sellable> objects, Class<T> type) {
        if (objects != null && objects.size() > 0) {
            if (type.isAssignableFrom(SalesLineItem.class)) {
                return this.unWrapAsSalesLineItem(objects);
            }
            if (type.isAssignableFrom(GiftVoucherTransaction.class)) {
                return this.unWrapAsVoucherTxn(objects);
            }
        }
        return new ArrayList(0);
    }

    private List<SalesLineItem> unWrapAsSalesLineItem(List<Sellable> objects) {
        ArrayList<SalesLineItem> salesLineItems = new ArrayList<SalesLineItem>();
        for (Sellable object : objects) {
            if (!(object instanceof SalesLineItemWrapper)) continue;
            salesLineItems.add((SalesLineItem)object.getSellingObject());
        }
        return salesLineItems;
    }

    private List<GiftVoucherTransaction> unWrapAsVoucherTxn(List<Sellable> objects) {
        ArrayList<GiftVoucherTransaction> voucherTxns = new ArrayList<GiftVoucherTransaction>();
        for (Sellable object : objects) {
            if (!(object instanceof VoucherTransactionWrapper)) continue;
            voucherTxns.add((GiftVoucherTransaction)object.getSellingObject());
        }
        return voucherTxns;
    }
}

