/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;

public enum StaleAccountType {
    ALL_OPEN_ACCOUNTS("<html>All <b>currently open</b> accounts</html>"){

        @Override
        public String getFunction() {
            return "SELECT * FROM sales_account where account_state = 'open'";
        }
    }
    ,
    ACCOUNTS_CREATED_BEFORE_TRADING_DAY("<html>Open accounts <b>created</b> before the <b>current trading day</b></html>"){

        @Override
        public String getFunction() {
            return Query.select(Account.class).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).not().equals(Account.Properties.TRADING_DAY, TradingDay.getCurrentTradingDay()).toString();
        }
    }
    ,
    ACCOUNTS_CREATED_NOT_CURRENT_SHIFT("<html>Open accounts <b>created</b> before the <b>current shift</b></html>"){

        @Override
        public String getFunction() {
            Shift currentShift = Shift.getCurrentShift();
            ObjectQuery query = Query.select(Account.class).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).not().equals(Account.Properties.SHIFT, currentShift);
            return query.toString();
        }
    };

    private final String label;

    private StaleAccountType(String description) {
        this.label = description;
    }

    public abstract String getFunction();

    public String toString() {
        return this.label;
    }
}

