/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.course.CoursePrintStatus;
import ordermate.database.course.SalesAccountCourse;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.CourseHoldStrategyHelper;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.customer.CustomerSeatLink;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.users.User;
import ordermate.integration.ReservationIntegrationUtils;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="TABLE")
@AccessType(value="property")
public class TableAccount
extends Account {
    public static final AccountType TYPE = AccountType.tableType;
    public static final Props Properties = new Props();
    private Reference<LogicalTable> table;
    private Reference<Course> currentCourse;
    private int seats;
    private String labelCache;
    private transient boolean ephemeral;
    private PersistentWriteableList<CustomerSeatLink> seatLinks;
    private PersistentWriteableList<SalesAccountCourse> salesAccountCourses;

    public TableAccount() {
        super(TYPE);
        this.table = this.createReference(TableAccount.Properties.TABLE);
        this.currentCourse = this.createReference(TableAccount.Properties.CURRENT_COURSE);
        this.ephemeral = false;
        this.seatLinks = this.createWriteableList(TableAccount.Properties.SEAT_LINKS);
        this.salesAccountCourses = this.createWriteableList(TableAccount.Properties.SALES_ACCOUNT_COURSES);
    }

    public TableAccount(User createUser, LogicalTable theTable, int numPatronsOnTable, Terminal createdOn) {
        this(TYPE, createUser, theTable, numPatronsOnTable, createdOn);
    }

    public TableAccount(AccountType type, User createUser, LogicalTable theTable, int numPatronsOnTable, Terminal createdOn) {
        super(new EventContext(createdOn, createUser), type == null ? TYPE : type);
        this.table = this.createReference(TableAccount.Properties.TABLE);
        this.currentCourse = this.createReference(TableAccount.Properties.CURRENT_COURSE);
        this.ephemeral = false;
        this.seatLinks = this.createWriteableList(TableAccount.Properties.SEAT_LINKS);
        this.salesAccountCourses = this.createWriteableList(TableAccount.Properties.SALES_ACCOUNT_COURSES);
        this.setTable(theTable);
        this.setNumPatrons(numPatronsOnTable);
        LogicalTableState state = LogicalTableState.getStateFor(AccountState.OPEN);
        if (state != null && theTable != null) {
            theTable.updateTableState(state, new EventContext(createdOn, createUser));
            this.setCurrentCourse(state.getCourse());
        }
        this.createSalesAccountCourse();
        this.getPriceAdjHelper().applyAutomaticAdjustment(new EventContext(createdOn, createUser), null);
    }

    @Override
    public boolean needsInfo() {
        return false;
    }

    @Override
    public void save() {
        if (!this.isOpen() && this.getItems().isEmpty()) {
            this.setNumPatrons(0);
        }
        super.save();
        this.seatLinks.saveChild();
        this.salesAccountCourses.saveChild();
        LogicalTable ourTable = this.getTable();
        if (ourTable == null || this.ephemeral) {
            return;
        }
        if (this.isOpen()) {
            if (ourTable.hasAccount() && !ourTable.getAccount().equals(this)) {
                throw new IllegalStateException("Table " + ourTable + " already has an account!");
            }
            ourTable.setAccount(this);
            ourTable.saveChild();
        } else if (ourTable.getAccount() != null && ourTable.getAccount().equals(this)) {
            ourTable.setAccount(null);
            ourTable.unlock();
            ourTable.saveChild();
        }
    }

    @Override
    public void close(EventContext context) {
        if (!this.ephemeral && this.getTable() != null) {
            this.getTable().updateTableState(LogicalTableState.getStateFor(AccountState.CLOSED), context);
            this.getTable().setAccount(null);
            this.getTable().saveChild();
        }
        super.close(context);
    }

    @Override
    public boolean usesSeatNums() {
        return this.getNumPatrons() > 1;
    }

    @JoinColumn(name="fk_config_course")
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    public Course getCurrentCourse() {
        return this.currentCourse.get();
    }

    public void setCurrentCourse(Course value) {
        this.currentCourse.set(value);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_config_table")
    public LogicalTable getTable() {
        if (this.table == null) {
            OrderMate.LOG.warn("The table member is not yet initialized, returning null.");
            return null;
        }
        return this.table.get();
    }

    public void setTable(LogicalTable newTable) {
        this.table.set(newTable);
        this.labelCache = null;
    }

    @Override
    public boolean lock(User user) {
        if (!this.isOpen() || this.ephemeral) {
            return super.lock(user);
        }
        boolean lockSucceeded = false;
        if (super.lock(user)) {
            if (this.getTable() == null) {
                lockSucceeded = true;
            } else if (this.getTable().getUser() == null) {
                lockSucceeded = this.getTable().lock(user);
                if (!lockSucceeded) {
                    super.unlock();
                }
            } else if (this.getTable().getUser().equals(user)) {
                lockSucceeded = true;
            } else {
                super.unlock();
                lockSucceeded = false;
            }
        }
        return lockSucceeded;
    }

    @Override
    public void unlock() {
        User accountUser = this.getUser();
        super.unlock();
        if (this.getTable() != null && !this.ephemeral) {
            User tableUser = this.getTable().getUser();
            if (accountUser != null && tableUser != null && tableUser.equals(accountUser)) {
                this.getTable().unlock();
            }
        }
    }

    @Override
    @Transient
    public String getLabel() {
        if (this.labelCache == null) {
            String s = "Table ";
            s = this.getTable() != null ? s + this.getTable().getGroupAndLabel() : s + "is unallocated";
            this.labelCache = s;
        }
        return this.labelCache;
    }

    public int evaluateNumberPatrons(Account target, List transferItems) {
        int retValue = this.getNumPatrons();
        if (!target.isPersistent() && target.getItems().isEmpty() && !this.getItems().equals(transferItems)) {
            int newNumPatrons = this.getNumPatrons() - target.getNumPatrons();
            retValue = newNumPatrons > 0 ? newNumPatrons : 1;
        }
        return retValue;
    }

    @Override
    public boolean isNumberPatronsModifiable(List itemsToTransfer) {
        return itemsToTransfer == null || !this.getItems().equals(itemsToTransfer);
    }

    @Override
    @Transient
    public boolean isClosePossible() {
        if (this.isAllocated()) {
            return super.isClosePossible();
        }
        if (ReservationIntegrationUtils.isCloudReservationsConfigured()) {
            if (!ReservationsHelper.getReservationsForTableAccount(this).isEmpty()) {
                return false;
            }
        } else if (this.getType().equals(AccountType.onlineTableType.getType())) {
            return super.isClosePossible();
        }
        return super.isClosePossible() && !this.hasItems();
    }

    @Transient
    public boolean isAllocated() {
        return this.table.getID() != null;
    }

    @Override
    public void printPrepDockets(Terminal printedFrom) throws Exception {
        if (this.isAllocated() || !printedFrom.isDeferUnallocatedTablePrepDockets()) {
            super.printPrepDockets(printedFrom);
        }
    }

    @Override
    public boolean allowsHold(Terminal term) {
        return this.isAllocated() && this.allowsOrderingItems() && term.isHoldTable() || super.allowsHold(term);
    }

    @Override
    public boolean requiresTicketDataName(Terminal term) {
        return !this.isAllocated() && term.getTableTicketDataName() && !this.hasTicketData();
    }

    @Override
    public boolean requiresTicketDataStandNum(Terminal terminal) {
        return !this.isAllocated() && terminal.isQuicksaleDineinStandNum() && !this.hasTicketData();
    }

    @Transient
    private boolean isItemsPrintPending() {
        List<SalesLineItem> allItems = this.getAllItems();
        for (SalesLineItem salesLineItem : allItems) {
            if (!salesLineItem.isPrinted()) {
                return true;
            }
            if (!(salesLineItem instanceof SalesCombo)) continue;
            SalesCombo combo = (SalesCombo)salesLineItem;
            for (SalesItem items : combo.getSalesItems()) {
                if (items.isPrinted()) continue;
                return true;
            }
        }
        return false;
    }

    @Transient
    private boolean isAnyCourseOnHold() {
        List<SalesAccountCourse> salesAccountCourseList = this.getSalesAccountCourses();
        for (SalesAccountCourse salesAccountCourse : salesAccountCourseList) {
            if (!salesAccountCourse.isCoursePrintOnHold()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        if (SystemProperty.getInstance().isSingleCoursePrinting()) {
            for (SalesLineItem lineItem : this.getItems()) {
                if (lineItem.isPrinted()) continue;
                return NOT_FULLY_PRINTED;
            }
        } else if (this.isAnyCourseOnHold() && this.isItemsPrintPending()) {
            return HOLD_COLOR;
        }
        return super.getBackgroundColor();
    }

    public void markEphemeral() {
        this.ephemeral = true;
    }

    @Column(name="seats")
    public int getSeats() {
        return this.seats;
    }

    public void setSeats(int seats) {
        this.seats = seats;
    }

    @Transient
    public void createSalesAccountCourse() {
        this.salesAccountCourses.addAll(CourseHoldStrategyHelper.createSalesAccountCourseLinks(this));
    }

    @Transient
    public List<SalesAccountCourse> getSalesAccountCourses() {
        return this.salesAccountCourses.getUnmodifiable();
    }

    @Transient
    public SalesAccountCourse getSalesAccountCourse(Course course) {
        if (course == null) {
            return null;
        }
        SalesAccountCourse result = null;
        for (SalesAccountCourse salesAccountCourse : this.salesAccountCourses) {
            if (salesAccountCourse.getCourse().getCourseIndex() != course.getCourseIndex()) continue;
            result = salesAccountCourse;
            break;
        }
        return result;
    }

    @Transient
    public SalesAccountCourse getSalesAccountCourse(int index) {
        String[] courseNames = Account.getCourses();
        Course course = Course.getCourseByName(courseNames[index]);
        return this.getSalesAccountCourse(course);
    }

    @Transient
    public boolean isCoursePrintOnHold(Course course) {
        SalesAccountCourse salesAccountCourse = this.getSalesAccountCourse(course);
        if (salesAccountCourse == null) {
            OrderMate.LOG.warn("SalesAccountCourse is null for Table Account " + this.getLabel() + " for Course : " + course.getName());
            return false;
        }
        return salesAccountCourse.getCoursePrintStatus() == CoursePrintStatus.HOLD;
    }

    @Transient
    public boolean isCoursePrintOnHold(int index) {
        SalesAccountCourse salesAccountCourse = this.getSalesAccountCourse(index);
        if (salesAccountCourse == null) {
            OrderMate.LOG.warn("SalesAccountCourse is null for Table Account " + this.getLabel() + " for Course Index : " + index);
            return false;
        }
        return salesAccountCourse.getCoursePrintStatus() == CoursePrintStatus.HOLD;
    }

    @Transient
    public void setCoursePrintOnHold(int index, boolean hold) {
        SalesAccountCourse salesAccountCourse = this.getSalesAccountCourse(index);
        if (salesAccountCourse == null) {
            OrderMate.LOG.warn("SalesAccountCourse is null for Table Account " + this.getLabel() + " for Course index : " + index + " hold : " + hold);
            return;
        }
        CoursePrintStatus coursePrintStatus = hold ? CoursePrintStatus.HOLD : CoursePrintStatus.PRINT;
        salesAccountCourse.setCoursePrintStatus(coursePrintStatus);
        salesAccountCourse.save();
    }

    public void setLastPrintedTime(int index, Date lastPrintedTime) {
        SalesAccountCourse salesAccountCourse = this.getSalesAccountCourse(index);
        if (salesAccountCourse != null) {
            salesAccountCourse.setLastPrintedTime(lastPrintedTime);
            salesAccountCourse.save();
        }
    }

    @Transient
    public List<CustomerSeatLink> getSeatLinks() {
        return this.seatLinks.getUnmodifiable();
    }

    protected void setSeatLinks(List<CustomerSeatLink> seatLinks) {
        this.seatLinks.set(seatLinks);
    }

    @Transient
    public void addSeatLink(CustomerSeatLink link) {
        if (!this.seatLinks.contains(link)) {
            this.seatLinks.add(link);
        }
    }

    @Transient
    public void removeSeatLink(CustomerSeatLink link) {
        this.seatLinks.remove(link);
    }

    @Transient
    public void removeSeatLinks(List<CustomerSeatLink> toRemove) {
        this.seatLinks.removeAll(toRemove);
    }

    public void removeSeatLink(int seat) {
        CustomerSeatLink toRemove = null;
        for (CustomerSeatLink link : this.seatLinks) {
            if (link.getSeat() != seat) continue;
            toRemove = link;
            break;
        }
        if (toRemove != null) {
            this.removeSeatLink(toRemove);
        }
    }

    @Transient
    public Customer getCustomerForSeat(int seat) {
        for (CustomerSeatLink link : this.getSeatLinks()) {
            if (link.getSeat() != seat) continue;
            return link.getCustomer();
        }
        return null;
    }

    @Transient
    public List<SalesLineItem> getItemsForCustomer(Customer customer) {
        ArrayList<SalesLineItem> matching = new ArrayList<SalesLineItem>();
        for (SalesLineItem item : this.getItems()) {
            if (customer == null || !customer.equals(item.getCustomer())) continue;
            matching.add(item);
        }
        return matching;
    }

    @Transient
    public List<SalesLineItem> getItemsForSeat(int seat) {
        ArrayList<SalesLineItem> matching = new ArrayList<SalesLineItem>();
        for (SalesLineItem item : this.getItems()) {
            if (item.getSeat() != seat) continue;
            matching.add(item);
        }
        return matching;
    }

    @Transient
    public List<Sellable> getSellablesForSeat(int seat) {
        SellableWrapperFactory factory = new SellableWrapperFactory();
        ArrayList<Sellable> matching = new ArrayList<Sellable>();
        for (Sellable sellable : factory.getSellables(this)) {
            if (sellable.getSeat() != seat) continue;
            matching.add(sellable);
        }
        return matching;
    }

    public static class Props
    extends Account.Props {
        public PropertiedObject.Property<LogicalTable> TABLE;
        public PropertiedObject.Property<Course> CURRENT_COURSE;
        public PropertiedObject.Property SEATS;
        public PropertiedObject.Property<CustomerSeatLink> SEAT_LINKS;
        public PropertiedObject.Property<SalesAccountCourse> SALES_ACCOUNT_COURSES;
    }
}

