/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AbstractTakeawayAccount;
import ordermate.database.sales.AccountType;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="TAKE_AWAY")
@AccessType(value="property")
public class TakeawayAccount
extends AbstractTakeawayAccount {
    public static final AccountType TYPE = AccountType.takeawayType;
    public static final Props Properties = new Props();
    boolean requiresEatInTicket = false;
    boolean isQuickSaleOriginated = false;

    public TakeawayAccount() {
        super(TYPE);
    }

    public TakeawayAccount(User createUser, Terminal createdOn) {
        super(createUser, createdOn, TYPE);
    }

    public TakeawayAccount(User createUser, Terminal createdOn, AccountType accType) {
        super(createUser, createdOn, accType);
    }

    @Override
    @Transient
    public String getLabel() {
        if (this.isPersistent()) {
            return super.getLabel();
        }
        return "New Takeaway";
    }

    @Override
    @Transient
    public String getRendererLabel() {
        return Long.toString(this.intID());
    }

    @Override
    public boolean requiresTicketDataName(Terminal terminal) {
        if (AccountType.takeawayType.equals(this.getAccountType())) {
            if (this.isQuickSaleOriginated()) {
                return terminal.isQuicksaleTakeawayStandName();
            }
        } else if (AccountType.quickSaleDineInType.equals(this.getAccountType())) {
            return terminal.isQuicksaleDineinStandName();
        }
        return terminal.isTakeawayStandName();
    }

    @Override
    public boolean requiresTicketDataEatIn(Terminal terminal) {
        return this.requiresEatInTicket;
    }

    @Override
    public boolean requiresTicketDataStandNum(Terminal terminal) {
        if (AccountType.takeawayType.equals(this.getAccountType())) {
            if (this.isQuickSaleOriginated()) {
                return terminal.isQuicksaleTakeawayStandNum();
            }
        } else if (AccountType.quickSaleDineInType.equals(this.getAccountType())) {
            return terminal.isQuicksaleDineinStandNum();
        }
        return terminal.isTakeawayStandNum();
    }

    @Override
    public boolean allowsHold(Terminal term) {
        return this.allowsOrderingItems() && term.isHoldTakeaway() || super.allowsHold(term);
    }

    @Override
    public boolean shouldAutoFillAccount() {
        return SystemProperty.getInstance().isAutoFillLastItemsTakeaway();
    }

    public void setRequiresEatInTicket(boolean requiresEatInTicket) {
        this.requiresEatInTicket = requiresEatInTicket;
    }

    public void setQuickSaleOriginated(boolean qsOriginated) {
        this.isQuickSaleOriginated = qsOriginated;
    }

    @Transient
    public boolean isQuickSaleOriginated() {
        return this.isQuickSaleOriginated;
    }

    public static class Props
    extends AbstractTakeawayAccount.Props {
    }
}

