/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.sales.Account;

public class TakeawayTicketData
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<Account> account;
    private String text;

    public TakeawayTicketData() {
        this.account = this.createReference(TakeawayTicketData.Properties.ACCOUNT);
        this.text = "";
    }

    public TakeawayTicketData(String ticketText) {
        this.account = this.createReference(TakeawayTicketData.Properties.ACCOUNT);
        if (ticketText == null) {
            throw new IllegalArgumentException("Ticket text cannot be null");
        }
        this.text = ticketText;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    protected Account getAccount() {
        return this.account.get();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    protected void setText(String text) {
        this.text = text;
    }

    protected void setAccount(Account account) {
        this.account.set(account);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TEXT;
        public PropertiedObject.Property ACCOUNT;
    }
}

