/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SellableWrapper;

public class VoucherTransactionWrapper
extends SellableWrapper {
    private final GiftVoucherTransaction voucherTxn;
    public static final String labelPrefix = "VOUCHER: ";

    public VoucherTransactionWrapper(GiftVoucherTransaction transaction) {
        this.voucherTxn = transaction;
    }

    @Override
    public int getCourse() {
        return 0;
    }

    @Override
    public int getSeat() {
        return 0;
    }

    @Override
    public boolean isModifiable(EventContext context) {
        return false;
    }

    @Override
    public Price getChargeablePrice() {
        return this.voucherTxn.getAmount();
    }

    @Override
    public Account getAccount() {
        return this.voucherTxn.getAccount();
    }

    @Override
    public SalesQuantity getQuantity() {
        return null;
    }

    @Override
    public boolean hasFinanceTransactions() {
        return this.voucherTxn.isAuthorised() && this.voucherTxn.getFinanceTransaction() != null;
    }

    @Override
    public boolean canHaveItemsWithin() {
        return false;
    }

    @Override
    public List<SalesItem> getSalesItems() {
        return new ArrayList<SalesItem>();
    }

    @Override
    public Customer getCustomer() {
        return this.voucherTxn.getGiftVoucher().getCustomer();
    }

    @Override
    public SalesQuantity getSavedQuantity(boolean printed) {
        return null;
    }

    @Override
    public boolean hasDisplayablePriceLevels() {
        return false;
    }

    @Override
    public String getDisplayablePriceLevels() {
        return "";
    }

    @Override
    public Price getPrice() {
        return this.voucherTxn.getAmount();
    }

    @Override
    public Price getItemLevelPrice() {
        return this.voucherTxn.getAmount();
    }

    @Override
    public boolean isQuantifiable() {
        return false;
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public boolean isPriceAdjustable() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return this.voucherTxn.isPersistent();
    }

    @Override
    public boolean isUpgradeable() {
        return false;
    }

    @Override
    public boolean isPriceEdited() {
        return false;
    }

    @Override
    public boolean isPrintable() {
        return true;
    }

    @Override
    public boolean isPrinted() {
        return this.voucherTxn.isPersistent();
    }

    @Override
    public Collection<SalesPriceAdjustment> getPriceAdjustments() {
        return null;
    }

    @Override
    public boolean isRefund() {
        return !this.voucherTxn.isActive() && this.voucherTxn.getAuthId() != null && !this.voucherTxn.getAuthId().isEmpty();
    }

    @Override
    public GiftVoucherTransaction getSellingObject() {
        return this.voucherTxn;
    }

    @Override
    public boolean canBeHeld() {
        return false;
    }

    @Override
    public boolean isWastageCheckNeeded() {
        return false;
    }

    @Override
    public boolean hasGenericIcon() {
        return true;
    }

    @Override
    public String getGenericIcon() {
        return "/waitermate/images/voucher.png";
    }

    @Override
    public Color getBackgroundColor() {
        if (this.voucherTxn.hasPayments()) {
            return PAID_COLOR;
        }
        return null;
    }

    @Override
    public Color getForegroundColor() {
        return null;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public String getLabel() {
        return labelPrefix + this.voucherTxn.getGiftVoucher().getUniqueId();
    }
}

