/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.coupon;

import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.coupon.ExistingCouponItemsAnalyser;

public class ExistingComboCouponItemsAnalyser
implements ExistingCouponItemsAnalyser<SalesItem> {
    private InventoryCombo inventoryCombo;

    public ExistingComboCouponItemsAnalyser(InventoryCombo inventoryCombo) {
        this.inventoryCombo = inventoryCombo;
    }

    @Override
    public boolean hasEligibleItems(List<? extends SalesLineItem> existingItems) {
        return this.getEligibleItems(existingItems).size() > 0;
    }

    @Override
    public List<SalesItem> getEligibleItems(List<? extends SalesLineItem> existingItems) {
        ArrayList<SalesItem> eligibleItems = new ArrayList<SalesItem>();
        for (SalesLineItem salesLineItem : existingItems) {
            if (!(salesLineItem instanceof SalesItem)) continue;
            for (InventoryComboGroup comboGroup : this.inventoryCombo.getGroups()) {
                if (!comboGroup.isMatchedItem(salesLineItem)) continue;
                eligibleItems.add((SalesItem)salesLineItem);
            }
        }
        return eligibleItems;
    }
}

