/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.coupon;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.HOMimic;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.users.User;

@Entity
@DiscriminatorValue(value="Combo")
public class SalesComboCouponUsage
extends SalesCouponUsage {
    public static final Props Properties = new Props();
    @HOMimic(mimic="salesRef", clazz=SalesCouponUsage.class)
    private Reference<SalesCombo> combo;

    public static SalesComboCouponUsage createUsage(SalesCombo combo, SalesCoupon coupon, TriggerActivationContext context) {
        return new SalesComboCouponUsage(combo, coupon, context.getTerminal(), context.getAccount(), context.getUser(), context.getCustomer() == null ? context.getAccount().getCustomer() : context.getCustomer(), context.getDate());
    }

    @Deprecated
    public SalesComboCouponUsage() {
        this.combo = this.createReference(SalesComboCouponUsage.Properties.COMBO);
    }

    private SalesComboCouponUsage(SalesCombo combo, SalesCoupon coupon, Terminal terminal, Account account, User user, Customer customer, Date date) {
        super(coupon, terminal, account, user, customer, date);
        this.combo = this.createReference(SalesComboCouponUsage.Properties.COMBO);
        this.setCombo(combo);
    }

    @Transient
    public SalesCombo getCombo() {
        return this.combo.get();
    }

    public void setCombo(SalesCombo newCombo) {
        if (this.combo.isNull()) {
            this.combo.set(newCombo);
            this.salesRef = this.combo.getID();
        } else if (!this.combo.get().equals(newCombo)) {
            throw new IllegalStateException("Cannot change the combo to which a coupon usage refers");
        }
    }

    @Column(name="fk_sales_combo")
    public Long getSalesRef() {
        return this.salesRef;
    }

    protected void setSalesRef(Long value) {
        this.salesRef = value;
    }

    public static class Props
    extends SalesCouponUsage.Props {
        public PropertiedObject.Property COMBO;
    }
}

