/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.coupon;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCouponUsage;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_coupon")
public class SalesCoupon
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<InventoryCoupon> inventoryCoupon;
    private Reference<Customer> customer;
    private PersistentWriteableList<SalesCouponUsage> usages;
    private SystemState systemState;
    private Date created;
    private Date activated;
    private Date firstUsed;
    private Date modTime;
    private String uniqueId;
    private int numUses;
    private boolean local;
    private transient String label;

    @Deprecated
    public SalesCoupon() {
        this.inventoryCoupon = this.createReference(SalesCoupon.Properties.INVENTORY_COUPON);
        this.customer = this.createReference(SalesCoupon.Properties.CUSTOMER);
        this.usages = this.createWriteableList(SalesCoupon.Properties.USAGES);
    }

    public SalesCoupon(InventoryCoupon templateCoupon, String uniqueId) {
        this.inventoryCoupon = this.createReference(SalesCoupon.Properties.INVENTORY_COUPON);
        this.customer = this.createReference(SalesCoupon.Properties.CUSTOMER);
        this.usages = this.createWriteableList(SalesCoupon.Properties.USAGES);
        this.inventoryCoupon.set(templateCoupon);
        this.created = new Date();
        this.systemState = SystemState.ACTIVE_STATE;
        this.local = templateCoupon.isLocal();
        this.numUses = 0;
        this.uniqueId = uniqueId;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="fk_inventory_coupon")
    public InventoryCoupon getInventoryCoupon() {
        return this.inventoryCoupon.get();
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="fk_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreated() {
        return this.created;
    }

    @Column(name="activated")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getActivated() {
        return this.activated;
    }

    @Column(name="mod_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getModTime() {
        return this.modTime;
    }

    @Column(name="unique_id")
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Column(name="num_uses")
    public int getNumUses() {
        return this.numUses;
    }

    protected void setInventoryCoupon(InventoryCoupon inventoryCoupon) {
        this.inventoryCoupon.set(inventoryCoupon);
    }

    public void setCustomer(Customer customer) {
        this.customer.set(customer);
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    protected void setCreated(Date created) {
        this.created = created;
    }

    public void setActivated(Date activated) {
        this.activated = activated;
    }

    protected void setModTime(Date modTime) {
        this.modTime = modTime;
    }

    public void setNumUses(int numUses) {
        this.numUses = numUses;
    }

    protected void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Column(name="local")
    public boolean isLocal() {
        return this.local;
    }

    protected void setLocal(boolean value) {
        this.local = value;
    }

    @Column(name="first_used")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getFirstUsed() {
        return this.firstUsed;
    }

    public void setFirstUsed(Date value) {
        if (this.firstUsed == null) {
            this.firstUsed = value;
        }
    }

    public void addUsage(SalesCouponUsage usage) {
        this.usages.add(usage);
    }

    public void removeUsage(SalesCouponUsage usage) {
        this.usages.remove(usage);
    }

    @OneToMany(mappedBy="coupon", targetEntity=SalesCouponUsage.class)
    public List<SalesCouponUsage> getUsages() {
        return this.usages;
    }

    protected void setUsages(List<SalesCouponUsage> newUsages) {
        this.usages = this.usages.clone();
        this.usages.set(newUsages);
    }

    @Override
    public void save() {
        this.modTime = new Date();
        PersistenceManager.save(this);
        this.usages.saveChild();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @PrePersist
    @PreUpdate
    public void prePersist() {
        this.modTime = new Date();
    }

    @Override
    public void delete() {
        this.setSystemState(SystemState.DELETED_STATE);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.getUniqueId() == null ? "<No ID>" : this.uniqueId;
    }

    @Transient
    public String getLabel() {
        if (this.label == null) {
            InventoryCoupon coupon = this.getInventoryCoupon();
            this.label = coupon != null ? (this.label = coupon.getLabel()) : "<Invalid Coupon>";
        }
        return this.label;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<InventoryCoupon> INVENTORY_COUPON;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<Date> CREATED;
        public PropertiedObject.Property<Date> ACTIVATED;
        public PropertiedObject.Property<Date> FIRST_USED;
        public PropertiedObject.Property<Date> MOD_TIME;
        public PropertiedObject.Property NUM_USES;
        public PropertiedObject.Property<String> UNIQUE_ID;
        public PropertiedObject.Property LOCAL;
        public PropertiedObject.Property USAGES;
        public PersistentObject.DerivedProperty<String> LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SalesCoupon.class), "label");
    }
}

