/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.coupon;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.users.User;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_coupon_usage")
@DiscriminatorColumn(name="coupon_type")
public abstract class SalesCouponUsage
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Date dateUsed;
    private Reference<SalesCoupon> coupon;
    private Reference<Terminal> terminal;
    private Reference<Account> account;
    private Reference<User> user;
    private Reference<Customer> customer;
    protected Long accountRef;
    protected Long salesRef;

    @Deprecated
    public SalesCouponUsage() {
        this.coupon = this.createReference(SalesCouponUsage.Properties.COUPON);
        this.terminal = this.createReference(SalesCouponUsage.Properties.TERMINAL);
        this.account = this.createReference(SalesCouponUsage.Properties.ACCOUNT);
        this.user = this.createReference(SalesCouponUsage.Properties.USER);
        this.customer = this.createReference(SalesCouponUsage.Properties.CUSTOMER);
    }

    public SalesCouponUsage(SalesCoupon yourCoupon, Terminal yourTerminal, Account yourAccount, User yourUser, Customer yourCustomer, Date theDate) {
        this.coupon = this.createReference(SalesCouponUsage.Properties.COUPON);
        this.terminal = this.createReference(SalesCouponUsage.Properties.TERMINAL);
        this.account = this.createReference(SalesCouponUsage.Properties.ACCOUNT);
        this.user = this.createReference(SalesCouponUsage.Properties.USER);
        this.customer = this.createReference(SalesCouponUsage.Properties.CUSTOMER);
        this.setCoupon(yourCoupon);
        this.setDateUsed(theDate);
        this.setTerminal(yourTerminal);
        this.setUser(yourUser);
        this.setAccount(yourAccount);
        this.setCustomer(yourCustomer);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        if (!SystemState.ACTIVE_STATE.equals(value) && !SystemState.DELETED_STATE.equals(value)) {
            throw new IllegalStateException("Cannot set the SalesCouponUsage state to " + value);
        }
        this.systemState = value;
    }

    @Column(name="date_of_use")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDateUsed() {
        return this.dateUsed;
    }

    protected void setDateUsed(Date used) {
        this.dateUsed = used;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_sales_coupon")
    public SalesCoupon getCoupon() {
        return this.coupon.get();
    }

    protected void setCoupon(SalesCoupon value) {
        this.coupon.set(value);
    }

    @Transient
    public Account getAccount() {
        return this.account.get();
    }

    protected void setAccount(Account value) {
        this.account.set(value);
        if (value != null) {
            this.accountRef = value.getID();
        }
    }

    @Column(name="fk_sales_account")
    public Long getAccountId() {
        return this.accountRef;
    }

    protected void setAccountId(Long value) {
        this.accountRef = value;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    protected void setTerminal(Terminal value) {
        this.terminal.set(value);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User value) {
        this.user.set(value);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    protected void setCustomer(Customer value) {
        this.customer.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.setSystemState(SystemState.DELETED_STATE);
        this.saveChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<SalesCoupon> COUPON;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Date> DATE_USED;
    }
}

