/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.coupon;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.HOMimic;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.users.User;

@Entity
@DiscriminatorValue(value="PriceAdjustment")
public class SalesPriceAdjustmentCouponUsage
extends SalesCouponUsage {
    public static final Props Properties = new Props();
    @HOMimic(mimic="salesRef", clazz=SalesCouponUsage.class)
    private Reference<SalesPriceAdjustment> adjustment;

    public static SalesPriceAdjustmentCouponUsage createUsage(SalesPriceAdjustment priceAdjustment, SalesCoupon coupon, TriggerActivationContext context) {
        return new SalesPriceAdjustmentCouponUsage(priceAdjustment, coupon, context.getTerminal(), context.getAccount(), context.getUser(), context.getCustomer() == null ? context.getAccount().getCustomer() : context.getCustomer(), context.getDate());
    }

    public SalesPriceAdjustmentCouponUsage() {
        this.adjustment = this.createReference(SalesPriceAdjustmentCouponUsage.Properties.ADJUSTMENT);
    }

    private SalesPriceAdjustmentCouponUsage(SalesPriceAdjustment priceAdjustment, SalesCoupon coupon, Terminal terminal, Account account, User user, Customer customer, Date date) {
        super(coupon, terminal, account, user, customer, date);
        this.adjustment = this.createReference(SalesPriceAdjustmentCouponUsage.Properties.ADJUSTMENT);
        this.setAdjustment(priceAdjustment);
    }

    @Transient
    public SalesPriceAdjustment getAdjustment() {
        return this.adjustment.get();
    }

    public void setAdjustment(SalesPriceAdjustment newAdjustment) {
        if (this.adjustment.isNull()) {
            this.adjustment.set(newAdjustment);
            this.salesRef = this.adjustment.getID();
        } else if (!this.adjustment.get().equals(newAdjustment)) {
            throw new IllegalStateException("Cannot change the PriceAdjustment to which a coupon usage refers");
        }
    }

    @Column(name="fk_sales_price_adjustment")
    public Long getSalesRef() {
        return this.salesRef;
    }

    protected void setSalesRef(Long value) {
        this.salesRef = value;
    }

    public static class Props
    extends SalesCouponUsage.Props {
        public PropertiedObject.Property<SalesPriceAdjustment> ADJUSTMENT;
    }
}

