/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer;

import au.com.ordermate.util.HtmlBuilder;
import java.text.SimpleDateFormat;
import ordermate.database.sales.Customer;

public class CustomerDetailHelper {
    private static final String GREY = "#B3B3B3";
    private final Customer customer;

    public CustomerDetailHelper(Customer theCustomer) {
        this.customer = theCustomer;
    }

    public String getName() {
        if (this.customer == null) {
            return this.makeItGrey("(No customer assigned)");
        }
        return this.customer.getName();
    }

    public String getCategory() {
        if (this.customer == null) {
            return null;
        }
        return this.customer.getCategoryLabel();
    }

    public String getPoints() {
        if (this.customer == null) {
            return null;
        }
        return this.customer.getLoyaltyPointsString() + " points";
    }

    public String getCardID() {
        if (this.customer == null) {
            return null;
        }
        if (this.customer.getCardID() == null || this.customer.getCardID().isEmpty()) {
            return this.makeItGrey("(No customer card)");
        }
        return "Card #" + this.customer.getCardID();
    }

    public String getTenure() {
        if (this.customer == null) {
            return null;
        }
        return "Member since " + new SimpleDateFormat("dd/MM/yyyy").format(this.customer.getCreationTime());
    }

    public String getComment() {
        if (this.customer == null) {
            return null;
        }
        if (this.customer.getComments() == null || this.customer.getComments().isEmpty()) {
            return this.makeItGrey("(No customer comment)");
        }
        return this.customer.getComments();
    }

    private String makeItGrey(String text) {
        return new HtmlBuilder().appendColor(text, GREY).toString();
    }
}

