/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.coupon.administration.CompositeCouponAdministrator;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.sales.Customer;

public class CustomerInterceptor
implements PersistenceListener {
    @Override
    public void objectChanged(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        if (PersistenceOperation.SAVE.equals((Object)operation) && Customer.class.isAssignableFrom(snapshot.getObjectType())) {
            this.applyNewCustomerOperations(snapshot);
        }
    }

    protected void applyNewCustomerOperations(PersistentObjectSnapshot snapshot) {
        CompositeCouponAdministrator coupons = CompositeCouponAdministrator.getInstance();
        if (coupons != null) {
            List<InventoryCoupon> autoCoupons = PersistenceManager.getObjectList(InventoryCoupon.class, Query.select(InventoryCoupon.class).equals(InventoryCoupon.Properties.AUTO_ASSIGN, Boolean.TRUE).equals(InventoryCoupon.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).equals(InventoryCoupon.Properties.LOCAL, Boolean.TRUE).equals(InventoryCoupon.Properties.PROTOTYPE, Boolean.TRUE).greaterThanOrEqual(InventoryCoupon.Properties.EXPIRES, new Date(), SQLDateType.TIMESTAMP).toString());
            for (InventoryCoupon coupon : autoCoupons) {
                coupons.generateSalesCoupons(coupon, Collections.singletonList(PersistenceManager.getByID(snapshot.getID(), Customer.class)));
            }
        }
    }
}

