/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.config.customer.CustomerInterest;
import ordermate.database.sales.Customer;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_customer_interest")
@AccessType(value="property")
public class CustomerInterestLink
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<Customer> customer;
    private Reference<CustomerInterest> interest;

    @Deprecated
    public CustomerInterestLink() {
        this.customer = this.createReference(CustomerInterestLink.Properties.CUSTOMER);
        this.interest = this.createReference(CustomerInterestLink.Properties.INTEREST);
    }

    public CustomerInterestLink(Customer cust, CustomerInterest custInterest) {
        this.customer = this.createReference(CustomerInterestLink.Properties.CUSTOMER);
        this.interest = this.createReference(CustomerInterestLink.Properties.INTEREST);
        if (cust == null) {
            throw new IllegalArgumentException("Customer cannot be null!");
        }
        if (this.interest == null) {
            throw new IllegalArgumentException("Customer interest cannot be null");
        }
        this.customer.set(cust);
        this.interest.set(custInterest);
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCustomer(Customer cust) {
        this.customer.set(cust);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_customer_interest")
    public CustomerInterest getInterest() {
        return this.interest.get();
    }

    public void setInterest(CustomerInterest custInterest) {
        this.interest.set(custInterest);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<CustomerInterest> INTEREST;
    }
}

