/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.assignment;

import java.util.List;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.CustomerAssignmentStrategy;
import ordermate.database.sales.customer.assignment.strategy.CustomerPerAccountStrategy;
import ordermate.database.sales.customer.assignment.strategy.CustomerPerSeatStrategy;

public class CustomerAssignmentHelper {
    public static final int UNKNOWN_SEAT = -2;

    public final CustomerAssignmentStrategy resolveStrategy(CustomerAssignmentContext context) {
        CustomerPerSeatStrategy strat;
        if (this.isAssignmentPerSeat(context.getAccount()) && (strat = new CustomerPerSeatStrategy(context)).isValid()) {
            return strat;
        }
        return new CustomerPerAccountStrategy(context);
    }

    public final boolean isAssignmentPerSeat(Account account) {
        return account != null && this.isAssignmentPerSeat(account.getAccountType());
    }

    public final boolean isAssignmentPerSeat(AccountType accType) {
        return SystemProperty.getInstance().isCustomerAssignmentPerSeat() && TableAccount.TYPE.equals(accType);
    }

    public final boolean assignCustomer(CustomerAssignmentContext context) {
        return this.resolveStrategy(context).assignCustomer();
    }

    public final boolean isCustomerAssigned(CustomerAssignmentContext context) {
        return this.resolveStrategy(context).isCustomerEqual();
    }

    public final Customer getAssignedCustomer(CustomerAssignmentContext context) {
        return this.resolveStrategy(context).getAssignedCustomer();
    }

    public final List<SalesLineItem> updateItemsForCustomer(CustomerAssignmentContext context) {
        return this.resolveStrategy(context).updateItemsForCustomer();
    }
}

