/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.assignment.strategy;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.CustomerCategoryTrigger;
import ordermate.database.inventory.triggers.DeliveryZoneTrigger;
import ordermate.database.inventory.triggers.LimitedPurchaseTrigger;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.CustomerAssignmentStrategy;

public abstract class AbstractCustomerStrategy
implements CustomerAssignmentStrategy {
    protected final CustomerAssignmentContext customerAssignContext;
    protected final Account account;
    protected final Customer customer;
    protected final EventContext eventContext;

    public AbstractCustomerStrategy(CustomerAssignmentContext context) {
        this.customerAssignContext = context;
        this.account = context.getAccount();
        this.customer = context.getCustomer();
        this.eventContext = context.getEventContext();
    }

    @Override
    public abstract boolean assignCustomer();

    @Override
    public abstract boolean isCustomerEqual();

    @Override
    public abstract Customer getAssignedCustomer();

    @Override
    public List<SalesLineItem> updateItemsForCustomer() {
        this.assignItemsToCustomer();
        this.assignVouchersToCustomer(this.getItemGroup());
        this.applyAdjustments();
        this.applyTriggers();
        this.applyRetroCustPriceUpdates();
        return this.finalizeAssignment();
    }

    protected void clearCustomerAdjustmentsOnAccount() {
        List<SalesPriceAdjustment> existing = PriceAdjustmentManager.getInstance().getMatching(this.account.getPriceAdjustments(), PriceAdjustmentType.CUSTOMER);
        for (SalesPriceAdjustment nextAdjustment : existing) {
            this.account.removePriceAdjustment(nextAdjustment, this.eventContext);
        }
    }

    protected abstract void assignItemsToCustomer();

    protected void assignVouchersToCustomer(ItemGroup itemGroup) {
        if (!itemGroup.getActiveVoucherTxns().isEmpty()) {
            for (GiftVoucherTransaction gvt : itemGroup.getActiveVoucherTxns()) {
                if (gvt.getGiftVoucher().getCustomer() != null) continue;
                OrderMate.LOG.info("Setting customer " + itemGroup.getCustomer().getName() + " to voucher: " + gvt.getGiftVoucher().getUniqueId());
                gvt.getGiftVoucher().setCustomer(this.customer);
                PersistenceManager.save(gvt.getGiftVoucher());
            }
        }
    }

    protected abstract ItemGroup getItemGroupForStrategy();

    protected void applyAdjustments() {
        this.clearCustomerAdjustmentsOnAccount();
        if (this.customer != null && this.customer.getPriceAdjustment() != null) {
            InventoryPriceAdjustment pa = this.customer.getPriceAdjustment();
            this.getItemGroupForStrategy().addSalesPriceAdjustment(pa.createSalesPriceAdjustment(this.getItemGroupForStrategy(), this.eventContext), this.eventContext);
        }
    }

    protected void applyTriggers() {
        Collection<AbstractTrigger> customerTriggers = AbstractTrigger.getTriggersByType(AbstractTrigger.Types.CUSTOMER_CATEGORY_TYPE);
        customerTriggers.addAll(AbstractTrigger.getTriggersByType(AbstractTrigger.Types.DELIVERY_ZONE_TYPE));
        this.getItemGroupForStrategy().getPriceAdjHelper().addTriggeredPriceAdjustmentbyTrigger(customerTriggers, this.eventContext);
    }

    protected void applyRetroCustPriceUpdates() {
        if (SystemProperty.getInstance().isRetroCustPriceUpdates()) {
            if (this.customer != null) {
                List<PriceLevel> priceLevels = PriceLevel.getWithTriggerType(CustomerCategoryTrigger.class);
                priceLevels.addAll(PriceLevel.getWithTriggerType(LimitedPurchaseTrigger.class));
                priceLevels.addAll(PriceLevel.getWithTriggerType(DeliveryZoneTrigger.class));
                this.getItemGroupForStrategy().getPriceAdjHelper().useHighestActivePriceLevel(new HashSet<PriceLevel>(priceLevels), false, this.eventContext, "Updating to customer price levels");
            } else {
                this.getItemGroupForStrategy().getPriceAdjHelper().useHighestActivePriceLevel(new HashSet<PriceLevel>(PriceLevel.getAllPriceLevels()), true, this.eventContext, "Removing customer price levels");
            }
        }
    }

    protected abstract List<SalesLineItem> finalizeAssignment();
}

