/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.assignment.strategy;

import au.com.ordermate.configuration.Config;
import java.util.ArrayList;
import java.util.List;
import ordermate.action.ActionManager;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.action.ActionFireOn;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.strategy.AbstractCustomerStrategy;

public class CustomerPerAccountStrategy
extends AbstractCustomerStrategy {
    public CustomerPerAccountStrategy(CustomerAssignmentContext context) {
        super(context);
    }

    @Override
    public boolean assignCustomer() {
        if (!(this.account == null || !this.account.isOpen() || this.account.hasCustomer() && this.getAssignedCustomer().equals(this.customer))) {
            this.account.setCustomer(this.customer, this.eventContext);
            if (Config.getBooleanValue("DoActionOnCustomerSet")) {
                ActionManager.getInstance().triggerAction(ActionFireOn.CustomerSet, new TriggerActivationContext(new TriggerActivationContext(this.eventContext, this.customer)));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCustomerEqual() {
        return this.account.hasCustomer() && this.getAssignedCustomer().equals(this.customer);
    }

    @Override
    public Customer getAssignedCustomer() {
        return this.account.getCustomer();
    }

    @Override
    public ItemGroup getItemGroup() {
        return this.account;
    }

    @Override
    protected void assignItemsToCustomer() {
        this.account.getItemHelper().setCustomerItems(this.customer);
    }

    @Override
    protected ItemGroup getItemGroupForStrategy() {
        return this.account;
    }

    @Override
    protected List<SalesLineItem> finalizeAssignment() {
        if (this.customer != null) {
            TerminalEventLog.logCustomerSetToAccount(this.eventContext, this.account);
            CustomerCardHelper helper = new CustomerCardHelper();
            CustomerCard card = helper.makeCard(this.customer.getCardID());
            if (card != null) {
                this.account.setCardId(card.getCardId());
            }
        }
        if (this.account.getCustomer() == null) {
            return new ArrayList<SalesLineItem>();
        }
        ArrayList<SalesLineItem> newItems = new ArrayList<SalesLineItem>();
        if (this.account.shouldAutoFillAccount()) {
            newItems.addAll(this.account.autoFillLastAccountForCustomer(this.eventContext));
        }
        return newItems;
    }
}

