/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.assignment.strategy;

import au.com.ordermate.configuration.Config;
import java.util.ArrayList;
import java.util.List;
import ordermate.action.ActionManager;
import ordermate.database.finance.CustomerPerSeatItemGroup;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.action.ActionFireOn;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.customer.CustomerSeatLink;
import ordermate.database.sales.customer.assignment.CustomerAssignmentContext;
import ordermate.database.sales.customer.assignment.strategy.AbstractCustomerStrategy;

public class CustomerPerSeatStrategy
extends AbstractCustomerStrategy {
    private final int seat;
    private final TableAccount tableAccount;
    private final CustomerPerSeatItemGroup customerSeatItemGroup;
    private final List<SalesLineItem> items;

    public CustomerPerSeatStrategy(CustomerAssignmentContext context) {
        super(context);
        this.seat = this.customerAssignContext.getSeatNumber();
        if (this.isAssignable()) {
            this.tableAccount = (TableAccount)this.account;
            this.items = this.tableAccount.getItemsForSeat(this.seat);
            this.customerSeatItemGroup = new CustomerPerSeatItemGroup(this.tableAccount, this.customer, new int[]{this.seat});
        } else {
            this.tableAccount = null;
            this.items = null;
            this.customerSeatItemGroup = null;
        }
    }

    public boolean isValid() {
        return this.tableAccount != null;
    }

    @Override
    public boolean assignCustomer() {
        if (this.isAssignable()) {
            ArrayList<CustomerSeatLink> toRemove = new ArrayList<CustomerSeatLink>();
            for (CustomerSeatLink link : this.tableAccount.getSeatLinks()) {
                if (link.getSeat() != this.seat) continue;
                toRemove.add(link);
            }
            this.tableAccount.removeSeatLinks(toRemove);
            CustomerSeatLink link = new CustomerSeatLink(this.seat, this.customer, this.tableAccount);
            this.tableAccount.addSeatLink(link);
            if (Config.getBooleanValue("DoActionOnCustomerSet")) {
                ActionManager.getInstance().triggerAction(ActionFireOn.CustomerSet, new TriggerActivationContext(new TriggerActivationContext(this.eventContext, this.customer)));
            }
            this.updateItemsForCustomer();
            return true;
        }
        return false;
    }

    private boolean isAssignable() {
        return this.customer != null && this.account != null && this.account.isOpen() && TableAccount.TYPE.equals(this.account.getAccountType()) && this.seat <= this.getMaxPatrons() && this.seat >= 0;
    }

    private int getMaxPatrons() {
        boolean isCoversAndSeatsSeparated = SystemProperty.getInstance().isCoversAndSeatsSeparated();
        if (AccountType.tableType.equals(this.account.getAccountType()) || AccountType.onlineTableType.equals(this.account.getAccountType())) {
            TableAccount tableAccount = (TableAccount)this.account;
            if (isCoversAndSeatsSeparated) {
                return tableAccount.getSeats();
            }
        }
        return this.account.getNumPatrons();
    }

    @Override
    public boolean isCustomerEqual() {
        for (CustomerSeatLink link : this.tableAccount.getSeatLinks()) {
            if (!link.getCustomer().equals(this.customer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Customer getAssignedCustomer() {
        for (CustomerSeatLink link : this.tableAccount.getSeatLinks()) {
            if (link.getSeat() != this.seat) continue;
            return link.getCustomer();
        }
        return null;
    }

    @Override
    public ItemGroup getItemGroup() {
        return this.customerSeatItemGroup;
    }

    @Override
    protected void assignItemsToCustomer() {
        for (SalesLineItem item : this.items) {
            item.setCustomer(this.customer);
        }
    }

    @Override
    protected ItemGroup getItemGroupForStrategy() {
        return this.customerSeatItemGroup;
    }

    @Override
    protected List<SalesLineItem> finalizeAssignment() {
        if (this.customer != null && -2 != this.seat) {
            TerminalEventLog.logCustomerSetToSeat(this.eventContext, this.tableAccount, this.seat);
        }
        return new ArrayList<SalesLineItem>();
    }
}

