/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.external;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.sales.Customer;

public class ExternalCustomer {
    private HashMap<PropertiedObject.Property, String> propertyValueMap = new HashMap();

    private ExternalCustomer(ExternalCustomerBuilder builder) {
        this.propertyValueMap.put(Customer.Properties.EXT_WEB_ID, builder.code);
        this.propertyValueMap.put(Customer.Properties.LAST_NAME, builder.lastName);
        this.propertyValueMap.put(Customer.Properties.FIRST_NAME, builder.firstName);
        this.propertyValueMap.put(Customer.Properties.TITLE, builder.title);
        this.propertyValueMap.put(Customer.Properties.ROOM_APT_NUMBER, builder.roomAptNum);
        this.propertyValueMap.put(Customer.Properties.HOUSE_NUMBER, builder.houseNum);
        this.propertyValueMap.put(Customer.Properties.STREET_NAME, builder.streetName);
        this.propertyValueMap.put(Customer.Properties.STREET_TYPE, builder.streetType);
        this.propertyValueMap.put(Customer.Properties.SUBURB, builder.suburb);
        this.propertyValueMap.put(Customer.Properties.STATE, builder.state);
        this.propertyValueMap.put(Customer.Properties.POSTCODE, builder.postCode);
        this.propertyValueMap.put(Customer.Properties.PRIMARY_PHONE_NUMBER, builder.phone);
        this.propertyValueMap.put(Customer.Properties.SECONDARY_PHONE_NUMBER, builder.mobile);
        this.propertyValueMap.put(Customer.Properties.E_MAIL, builder.email);
        this.propertyValueMap.put(Customer.Properties.GENDER, builder.gender);
        this.propertyValueMap.put(Customer.Properties.DOB, builder.birthday);
        this.propertyValueMap.put(Customer.Properties.CATEGORY, builder.type);
        this.propertyValueMap.put(Customer.Properties.CARD_ID, builder.scan);
    }

    public Map<PropertiedObject.Property, String> getPropertyValueMapping() {
        return Collections.unmodifiableMap(this.propertyValueMap);
    }

    public static class ExternalCustomerBuilder {
        private String code;
        private String lastName;
        private String firstName;
        private String title;
        private String roomAptNum;
        private String houseNum;
        private String streetName;
        private String streetType;
        private String suburb;
        private String state;
        private String postCode;
        private String phone;
        private String mobile;
        private String email;
        private String gender;
        private String birthday;
        private String type;
        private String scan;

        public ExternalCustomerBuilder(String code) {
            this.code = StringUtils.removeDoubleQuotes(code);
        }

        public ExternalCustomerBuilder lastName(String builderLastName) {
            this.lastName = StringUtils.removeDoubleQuotes(builderLastName);
            return this;
        }

        public ExternalCustomerBuilder firstName(String builderFirstName) {
            this.firstName = StringUtils.removeDoubleQuotes(builderFirstName);
            return this;
        }

        public ExternalCustomerBuilder title(String builderTitle) {
            this.title = StringUtils.removeDoubleQuotes(builderTitle);
            return this;
        }

        public ExternalCustomerBuilder roomAptNum(String builderRoomAptNum) {
            this.roomAptNum = StringUtils.removeDoubleQuotes(builderRoomAptNum);
            return this;
        }

        public ExternalCustomerBuilder houseNum(String builderHouseNum) {
            this.houseNum = StringUtils.removeDoubleQuotes(builderHouseNum);
            return this;
        }

        public ExternalCustomerBuilder streetName(String builderStreetName) {
            this.streetName = StringUtils.removeDoubleQuotes(builderStreetName);
            return this;
        }

        public ExternalCustomerBuilder streetType(String builderStreetType) {
            this.streetType = StringUtils.removeDoubleQuotes(builderStreetType);
            return this;
        }

        public ExternalCustomerBuilder suburb(String builderSuburb) {
            this.suburb = StringUtils.removeDoubleQuotes(builderSuburb);
            return this;
        }

        public ExternalCustomerBuilder state(String builderState) {
            this.state = StringUtils.removeDoubleQuotes(builderState);
            return this;
        }

        public ExternalCustomerBuilder postCode(String builderPostCode) {
            this.postCode = StringUtils.removeDoubleQuotes(builderPostCode);
            return this;
        }

        public ExternalCustomerBuilder phone(String builderPhone) {
            this.phone = StringUtils.removeDoubleQuotes(builderPhone);
            return this;
        }

        public ExternalCustomerBuilder mobile(String builderMobile) {
            this.mobile = StringUtils.removeDoubleQuotes(builderMobile);
            return this;
        }

        public ExternalCustomerBuilder email(String builderEmail) {
            this.email = StringUtils.removeDoubleQuotes(builderEmail);
            return this;
        }

        public ExternalCustomerBuilder gender(String builderGender) {
            this.gender = StringUtils.removeDoubleQuotes(builderGender);
            return this;
        }

        public ExternalCustomerBuilder birthday(String builderBirthday) {
            this.birthday = StringUtils.removeDoubleQuotes(builderBirthday);
            return this;
        }

        public ExternalCustomerBuilder type(String builderType) {
            this.type = StringUtils.removeDoubleQuotes(builderType);
            return this;
        }

        public ExternalCustomerBuilder scan(String builderScan) {
            this.scan = StringUtils.removeDoubleQuotes(builderScan);
            return this;
        }

        public ExternalCustomer build() {
            return new ExternalCustomer(this);
        }
    }
}

