/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.external;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ordermate.database.delivery.StreetType;
import ordermate.database.queries.delivery.StreetTypeQueries;
import org.apache.commons.lang.StringUtils;

public class ExternalCustomerAddressHelper {
    private static final String HOUSE_NUM_REGEX = "\\d+/?-?\\w*$";
    private static final String WHITESPACE_REGEX = "\\s+";
    private static final String SINGLE_WHITESPACE = " ";

    public static String getRoomAptNum(String addressLine) {
        Pattern pattern = Pattern.compile(HOUSE_NUM_REGEX);
        String[] components = addressLine.split(WHITESPACE_REGEX);
        ArrayList<String> matches = new ArrayList<String>();
        for (String component : components) {
            if (!StringUtils.isNumeric((String)component) && !pattern.matcher(component).find()) continue;
            matches.add(component);
        }
        if (matches.size() <= 1) {
            return "";
        }
        return (String)matches.get(0);
    }

    public static String getHouseNum(String addressLine) {
        Pattern pattern = Pattern.compile(HOUSE_NUM_REGEX);
        String[] components = addressLine.split(WHITESPACE_REGEX);
        ArrayList<String> matches = new ArrayList<String>();
        for (String component : components) {
            if (!StringUtils.isNumeric((String)component) && !pattern.matcher(component).find()) continue;
            matches.add(component);
        }
        if (matches.isEmpty()) {
            return "";
        }
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        return (String)matches.get(1);
    }

    public static String getStreetName(String addressLine) {
        String streetName = addressLine;
        streetName = streetName.replaceAll(ExternalCustomerAddressHelper.getRoomAptNum(addressLine), "");
        streetName = streetName.replaceAll(ExternalCustomerAddressHelper.getHouseNum(addressLine), "");
        return streetName.trim();
    }

    public static String getStreetType(String addressLine) {
        List<StreetType> streetTypes = StreetTypeQueries.getAllStreetTypes();
        for (StreetType streetType : streetTypes) {
            if (!ExternalCustomerAddressHelper.endsWith(addressLine, streetType.getName()) && !ExternalCustomerAddressHelper.endsWith(addressLine, streetType.getAbbreviation())) continue;
            return streetType.getName();
        }
        return "";
    }

    private static boolean endsWith(String toInspect, String suffix) {
        return toInspect.endsWith(SINGLE_WHITESPACE + suffix);
    }
}

