/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.external;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.queries.sales.CustomerCategoryQueries;
import ordermate.database.queries.sales.CustomerQueries;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.Gender;
import ordermate.database.sales.customer.external.ExternalCustomer;
import ordermate.database.sales.customer.external.interpreter.AbstractExternalCustomerInterpreter;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public class ExternalCustomerFieldMapper {
    private ExternalCustomer myExtCustomer;
    private AbstractExternalCustomerInterpreter interpreter;

    public ExternalCustomerFieldMapper(ExternalCustomer extCustomer, AbstractExternalCustomerInterpreter interpreter) {
        this.myExtCustomer = extCustomer;
        this.interpreter = interpreter;
    }

    public Customer map() throws Exception {
        Map<PropertiedObject.Property, String> propertyValueMap = this.myExtCustomer.getPropertyValueMapping();
        if (propertyValueMap != null) {
            Customer customer = this.getExistingOrCreateNew();
            for (Map.Entry<PropertiedObject.Property, String> entry : propertyValueMap.entrySet()) {
                this.setField(customer, entry.getKey(), entry.getValue());
            }
            return customer;
        }
        throw new InvalidInputException("Property value map is empty, cannot create a Customer with empty data!");
    }

    private Customer getExistingOrCreateNew() {
        if (this.extWebIDExists()) {
            String extWebId = this.myExtCustomer.getPropertyValueMapping().get(Customer.Properties.EXT_WEB_ID);
            return this.makeActive(CustomerQueries.getByExtWebId(extWebId));
        }
        if (this.emailExists()) {
            String email = this.myExtCustomer.getPropertyValueMapping().get(Customer.Properties.E_MAIL);
            return this.makeActive(PersistenceManager.getObject(Customer.class, CustomerQueries.getByEmail(email).toString()));
        }
        return new Customer();
    }

    private Customer makeActive(Customer customer) {
        customer.setSystemState("ACTIVE");
        return customer;
    }

    private boolean extWebIDExists() {
        String code = this.myExtCustomer.getPropertyValueMapping().get(Customer.Properties.EXT_WEB_ID);
        if (code == null || code.isEmpty()) {
            return false;
        }
        return CustomerQueries.getByExtWebId(code) != null;
    }

    private boolean emailExists() {
        String email = this.myExtCustomer.getPropertyValueMapping().get(Customer.Properties.E_MAIL);
        if (email == null || email.isEmpty()) {
            return false;
        }
        Customer customer = PersistenceManager.getObject(Customer.class, CustomerQueries.getByEmail(email).toString());
        return customer != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setField(Customer customer, PropertiedObject.Property property, String value) {
        Object valueToSet = value;
        if (Date.class.isAssignableFrom(property.getType())) {
            try {
                DateFormat format = this.interpreter.getDateFormat();
                valueToSet = format.parse(value);
                if (valueToSet == null && Config.isDebuging()) {
                    OrderMate.LOG.warn("Null date provided. Cannot set property value!");
                }
            }
            catch (ParseException e) {
                OrderMate.LOG.warn("Invalid date format given in ExternalCustomerFieldMapper " + e);
            }
        } else if (Customer.Properties.GENDER.equals(property)) {
            if (value == null || value.trim().length() <= 0) return;
            if (StringUtils.startsWithIgnoreCase(value, "m")) {
                valueToSet = Gender.Male;
            } else if (StringUtils.startsWithIgnoreCase(value, "f")) {
                valueToSet = Gender.Female;
            }
        } else if (Boolean.class.isAssignableFrom(property.getType())) {
            if (value != null && value.length() > 0) {
                if (StringUtils.startsWithIgnoreCase(value, "t") || "1".equals(value)) {
                    valueToSet = Boolean.TRUE;
                } else if (StringUtils.startsWithIgnoreCase(value, "f") || "0".equals(value)) {
                    valueToSet = Boolean.FALSE;
                }
            }
        } else if (Customer.Properties.CATEGORY.equals(property)) {
            CustomerCategory category;
            long ID;
            CustomerCategory category2;
            CustomerCategory defaultCategory = CustomerCategoryQueries.getDefaultCustomerCategory();
            valueToSet = value != null && StringUtils.isNumeric(value) ? ((category2 = CustomerCategoryQueries.getCategoryById(ID = Long.parseLong(value))) != null ? category2 : defaultCategory) : (value != null && StringUtils.isAlphaNumericIncludingSpace(value) ? ((category = CustomerCategoryQueries.getCategory(value)) != null ? category : defaultCategory) : defaultCategory);
        } else if (Customer.Properties.SECONDARY_PHONE_NUMBER.equals(property) && (valueToSet == null || valueToSet.toString().trim().length() == 0)) {
            valueToSet = "0123456789";
        }
        PropertiedObject.PropsHelper.setPropertyValue(customer, property, valueToSet);
    }
}

