/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.external;

import au.com.ordermate.csv.CSVUtils;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.sales.Customer;
import ordermate.database.sales.customer.external.ExternalCustomer;
import ordermate.database.sales.customer.external.ExternalCustomerFieldMapper;
import ordermate.database.sales.customer.external.interpreter.AbstractExternalCustomerInterpreter;

public class ExternalCustomerImporter {
    private AbstractExternalCustomerInterpreter myInterpreter;
    private static final String DEFAULT_DIR = "C:\\temp\\customers\\";
    private static final String DEFAULT_FILENAME = "ordermate.csv";
    private static final String DEFAULT_DELIMITER = ",";
    public static final String EXPERIMENTAL_FEATURE_NAME = "importExternalCustomer";

    public ExternalCustomerImporter(AbstractExternalCustomerInterpreter interpreter) {
        this.myInterpreter = interpreter;
    }

    public boolean importExternalCustomers() {
        String filePath = this.getFilePath();
        if (filePath == null || filePath.isEmpty()) {
            OrderMate.LOG.warn("Could not proceed with import of External Customers. Filepath is either null or empty!");
            return false;
        }
        ArrayList<Customer> customers = new ArrayList<Customer>();
        try {
            List<List<String>> rows = CSVUtils.readCSVFile(filePath, this.myInterpreter.getDelimiter());
            OrderMate.LOG.info("Number of rows from csv : " + rows.size());
            rows = this.excludeHeaders(rows);
            List<ExternalCustomer> extCustomerList = this.myInterpreter.interpretExternalCustomers(rows);
            for (ExternalCustomer extCustomer : extCustomerList) {
                try {
                    ExternalCustomerFieldMapper mapper = new ExternalCustomerFieldMapper(extCustomer, this.myInterpreter);
                    customers.add(mapper.map());
                }
                catch (Exception ex) {
                    OrderMate.LOG.info("Failed to save record " + extCustomer.toString());
                }
            }
            this.saveCustomers(customers);
            return true;
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Invalid filepath : " + this.getFilePath() + "! Make sure the directory and filename is correct.", (Throwable)ex);
            return false;
        }
        catch (IllegalArgumentException ex) {
            OrderMate.LOG.error("File path is empty!", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("An exception has occurred, cannot import and save external customer(s).", (Throwable)ex);
            return false;
        }
    }

    private List<List<String>> excludeHeaders(List<List<String>> rows) {
        if (this.myInterpreter.hasHeaders()) {
            return rows.subList(1, rows.size());
        }
        return rows;
    }

    public String getDefaultFileName() {
        return DEFAULT_FILENAME;
    }

    public String getDelimiter() {
        return DEFAULT_DELIMITER;
    }

    public String getFilePath() {
        ExperimentalFeature expFeature = ExperimentalFeature.find(EXPERIMENTAL_FEATURE_NAME);
        return expFeature == null ? DEFAULT_DIR + this.getDefaultFileName() : expFeature.getValue();
    }

    private void saveCustomers(List<Customer> customerList) {
        for (Customer toSave : customerList) {
            PersistenceManager.save(toSave);
            OrderMate.LOG.info("Successfully imported and saved customer with name : " + toSave.getFirstName() + " " + toSave.getLastName());
        }
    }
}

