/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.external.interpreter;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.sales.customer.external.ExternalCustomer;
import ordermate.database.sales.customer.external.ExternalCustomerAddressHelper;
import ordermate.database.sales.customer.external.ExternalCustomerField;

public abstract class AbstractExternalCustomerInterpreter {
    private List<ExternalCustomer> myExternalCustomers;
    private HashMap<ExternalCustomerField, Integer> myColumnIndexMap = this.createColumnIndexMap();

    public AbstractExternalCustomerInterpreter() {
        this.myExternalCustomers = new ArrayList<ExternalCustomer>();
    }

    protected abstract HashMap<ExternalCustomerField, Integer> createColumnIndexMap();

    public abstract boolean hasHeaders();

    public abstract DateFormat getDateFormat();

    public List<ExternalCustomer> interpretExternalCustomers(List<List<String>> rows) throws Exception {
        for (List<String> row : rows) {
            try {
                ExternalCustomer extCustomer = this.createExternalCustomer(row);
                if (extCustomer == null) continue;
                this.myExternalCustomers.add(extCustomer);
            }
            catch (Exception ex) {
                OrderMate.LOG.info(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.myExternalCustomers;
    }

    public String getDelimiter() {
        return ",";
    }

    public Map<ExternalCustomerField, Integer> getColumnIndexMap() {
        return Collections.unmodifiableMap(this.myColumnIndexMap);
    }

    protected ExternalCustomer createExternalCustomer(List<String> entry) {
        try {
            String code = entry.get(this.getIndexFor(ExternalCustomerField.CODE));
            String lastName = entry.get(this.getIndexFor(ExternalCustomerField.LASTNAME));
            String firstName = entry.get(this.getIndexFor(ExternalCustomerField.FIRSTNAME));
            String title = entry.get(this.getIndexFor(ExternalCustomerField.TITLE));
            String address1 = entry.get(this.getIndexFor(ExternalCustomerField.ADDRESS1));
            String roomAptNum = ExternalCustomerAddressHelper.getRoomAptNum(address1);
            String houseNum = ExternalCustomerAddressHelper.getHouseNum(address1);
            String streetName = ExternalCustomerAddressHelper.getStreetName(address1);
            String streetType = ExternalCustomerAddressHelper.getStreetType(address1);
            String suburb = entry.get(this.getIndexFor(ExternalCustomerField.SUBURB));
            String state = entry.get(this.getIndexFor(ExternalCustomerField.STATE));
            String postCode = entry.get(this.getIndexFor(ExternalCustomerField.POSTCODE));
            String phone = entry.get(this.getIndexFor(ExternalCustomerField.PHONE));
            String mobile = entry.get(this.getIndexFor(ExternalCustomerField.MOBILE));
            String email = entry.get(this.getIndexFor(ExternalCustomerField.EMAIL));
            String gender = entry.get(this.getIndexFor(ExternalCustomerField.GENDER));
            String birthday = entry.get(this.getIndexFor(ExternalCustomerField.DOB));
            String type = entry.get(this.getIndexFor(ExternalCustomerField.TYPE));
            String scan = entry.get(this.getIndexFor(ExternalCustomerField.SCAN));
            ExternalCustomer extCustomer = new ExternalCustomer.ExternalCustomerBuilder(code).lastName(lastName).firstName(firstName).title(title).roomAptNum(roomAptNum).houseNum(houseNum).streetName(streetName).streetType(streetType).suburb(suburb).state(state).postCode(postCode).phone(phone).mobile(mobile).email(email).gender(gender).birthday(birthday).type(type).scan(scan).build();
            return extCustomer;
        }
        catch (IndexOutOfBoundsException e) {
            OrderMate.LOG.error("Index out of bounds, cannot create a new ExternalCustomer", (Throwable)e);
            return null;
        }
    }

    protected Integer getIndexFor(ExternalCustomerField field) {
        return this.myColumnIndexMap.get((Object)field);
    }
}

