/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.customer.external.interpreter;

import au.com.ordermate.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.sales.customer.external.ExternalCustomer;
import ordermate.database.sales.customer.external.ExternalCustomerAddressHelper;
import ordermate.database.sales.customer.external.ExternalCustomerField;
import ordermate.database.sales.customer.external.interpreter.AbstractExternalCustomerInterpreter;

public class MemberJungleExternalCustomerInterpreter
extends AbstractExternalCustomerInterpreter {
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");

    @Override
    protected HashMap<ExternalCustomerField, Integer> createColumnIndexMap() {
        HashMap<ExternalCustomerField, Integer> indexMap = new HashMap<ExternalCustomerField, Integer>();
        indexMap.put(ExternalCustomerField.FIRSTNAME, 0);
        indexMap.put(ExternalCustomerField.LASTNAME, 2);
        indexMap.put(ExternalCustomerField.TITLE, 3);
        indexMap.put(ExternalCustomerField.CODE, 5);
        indexMap.put(ExternalCustomerField.SCAN, 6);
        indexMap.put(ExternalCustomerField.GENDER, 7);
        indexMap.put(ExternalCustomerField.DOB, 8);
        indexMap.put(ExternalCustomerField.EMAIL, 9);
        indexMap.put(ExternalCustomerField.MOBILE, 11);
        indexMap.put(ExternalCustomerField.PHONE, 12);
        indexMap.put(ExternalCustomerField.TYPE, 13);
        indexMap.put(ExternalCustomerField.ADDRESS1, 19);
        indexMap.put(ExternalCustomerField.ADDRESS2, 20);
        indexMap.put(ExternalCustomerField.STATE, 22);
        indexMap.put(ExternalCustomerField.POSTCODE, 24);
        return indexMap;
    }

    @Override
    public String getDelimiter() {
        return "\",\"";
    }

    @Override
    protected ExternalCustomer createExternalCustomer(List<String> entry) {
        try {
            String code = entry.get(this.getIndexFor(ExternalCustomerField.CODE));
            String lastName = entry.get(this.getIndexFor(ExternalCustomerField.LASTNAME));
            String firstName = entry.get(this.getIndexFor(ExternalCustomerField.FIRSTNAME));
            String title = entry.get(this.getIndexFor(ExternalCustomerField.TITLE));
            String address1 = entry.get(this.getIndexFor(ExternalCustomerField.ADDRESS1));
            String roomAptNum = ExternalCustomerAddressHelper.getRoomAptNum(address1);
            String houseNum = ExternalCustomerAddressHelper.getHouseNum(address1);
            String streetName = ExternalCustomerAddressHelper.getStreetName(address1);
            String streetType = ExternalCustomerAddressHelper.getStreetType(address1);
            String state = entry.get(this.getIndexFor(ExternalCustomerField.STATE));
            String postCode = entry.get(this.getIndexFor(ExternalCustomerField.POSTCODE));
            String phone = entry.get(this.getIndexFor(ExternalCustomerField.PHONE));
            String mobile = entry.get(this.getIndexFor(ExternalCustomerField.MOBILE));
            String email = entry.get(this.getIndexFor(ExternalCustomerField.EMAIL));
            String gender = entry.get(this.getIndexFor(ExternalCustomerField.GENDER));
            String birthday = entry.get(this.getIndexFor(ExternalCustomerField.DOB));
            String type = entry.get(this.getIndexFor(ExternalCustomerField.TYPE));
            String scan = entry.get(this.getIndexFor(ExternalCustomerField.SCAN));
            if (StringUtils.isEmpty(StringUtils.removeDoubleQuotes(birthday))) {
                birthday = "01-Jan-1900";
            }
            scan = StringUtils.removeDoubleQuotes(scan);
            scan = scan.replaceFirst("^0*", "");
            if (StringUtils.isEmpty(title = StringUtils.removeDoubleQuotes(title))) {
                title = "Ms";
            }
            if (StringUtils.isEmpty(mobile = StringUtils.removeDoubleQuotes(mobile))) {
                mobile = "n/a";
            }
            if (StringUtils.isEmpty(gender = StringUtils.removeDoubleQuotes(gender))) {
                gender = "Female";
            }
            ExternalCustomer extCustomer = new ExternalCustomer.ExternalCustomerBuilder(code).lastName(lastName).firstName(firstName).title(title).roomAptNum(roomAptNum).houseNum(houseNum).streetName(streetName).streetType(streetType).state(state).postCode(postCode).phone(phone).mobile(mobile).email(email).gender(gender).birthday(birthday).type(type).scan(scan).build();
            return extCustomer;
        }
        catch (IndexOutOfBoundsException e) {
            OrderMate.LOG.error("Index out of bounds, cannot create a new ExternalCustomer", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasHeaders() {
        return true;
    }

    @Override
    public DateFormat getDateFormat() {
        return this.simpleDateFormat;
    }
}

