/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.itemfilter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.ItemFilter;

public class ComboGroupFilter
extends ItemFilter {
    private final Set<InventoryItemUnit> itemSet = new HashSet<InventoryItemUnit>();

    public ComboGroupFilter(InventoryComboGroup comboGroup) {
        this.itemSet.addAll(comboGroup.getAllItemUnits());
    }

    @Override
    public boolean itemBelongs(SalesLineItem toCheck) {
        if (toCheck instanceof SalesCombo) {
            return false;
        }
        SalesItem checkItem = (SalesItem)toCheck;
        ArrayList<InventoryItemUnit> unitsInItem = new ArrayList<InventoryItemUnit>();
        for (SalesComponent comp : checkItem.getComponentList()) {
            unitsInItem.add(comp.getUnit());
        }
        return this.itemSet.containsAll(unitsInItem);
    }
}

