/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.itemfilter;

import java.util.List;
import ordermate.OrderMate;
import ordermate.database.course.CoursePrintStatus;
import ordermate.database.course.SalesAccountCourse;
import ordermate.database.misc.Course;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.itemfilter.ItemFilter;

public class CourseHoldFilter
extends ItemFilter {
    @Override
    protected boolean itemBelongs(SalesLineItem toCheck) {
        Account account = toCheck.getAccount();
        if (!(account instanceof TableAccount)) {
            return true;
        }
        TableAccount tableAccount = (TableAccount)account;
        Course course = this.getCourse(toCheck.getCourse());
        SalesAccountCourse salesAccountCourse = tableAccount.getSalesAccountCourse(course);
        if (salesAccountCourse == null) {
            OrderMate.LOG.warn("SalesAccountCourse is null for Table Account " + tableAccount.getLabel() + " for Course : " + course);
            return true;
        }
        return salesAccountCourse.getCoursePrintStatus() == CoursePrintStatus.PRINT;
    }

    private Course getCourse(int index) {
        Course result = null;
        List<Course> courseList = Course.getCourses();
        for (Course course : courseList) {
            if (course.getCourseIndex() != index) continue;
            result = course;
            break;
        }
        return result;
    }
}

