/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.itemfilter;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.misc.DayPart;

public class TimeSearchFilter
extends RangeQuerySearchFilter<Calendar> {
    private boolean allDay = true;
    private DayPart dayPart;
    private boolean inclusive = true;
    private boolean isSupportCrossDay = false;

    public TimeSearchFilter(PropertiedObject.Property prop) {
        super(prop);
    }

    @Override
    public ObjectQuery addQueryRestriction(ObjectQuery query) {
        if (!this.isAllDay()) {
            Date start = ((Calendar)this.getStart()).getTime();
            Date end = ((Calendar)this.getEnd()).getTime();
            if (!this.isSupportCrossDay) {
                start = DateTimeUtils.cleanDatePart((Calendar)this.getStart()).getTime();
                end = DateTimeUtils.cleanDatePart((Calendar)this.getEnd()).getTime();
            }
            StringBuilder SB = new StringBuilder("time_to_sec(");
            SB.append(this.getProperty()).append(") ");
            if (start.after(end)) {
                SB.append(" NOT BETWEEN time_to_sec('").append(DateTimeUtils.get24HFormat().format(end)).append(":59') AND time_to_sec('").append(DateTimeUtils.get24HFormat().format(start)).append(this.inclusive ? ":59')" : ":00')");
            } else if (!this.isSupportCrossDay) {
                SB.append("BETWEEN time_to_sec('").append(DateTimeUtils.get24HFormat().format(start)).append(":00') AND time_to_sec('").append(DateTimeUtils.get24HFormat().format(end)).append(this.inclusive ? ":59')" : ":00')");
            } else {
                SB.append("BETWEEN time_to_sec('").append(start).append("') AND time_to_sec('").append(end).append("')");
            }
            query.whereFunction(SB.toString());
        }
        return query;
    }

    @Override
    public boolean hasSearchValue() {
        if (this.isAllDay()) {
            return false;
        }
        return super.hasSearchValue();
    }

    @Override
    public IRangedSearchFilter setStart(Calendar newStartPoint) {
        this.allDay = newStartPoint == null && this.getEnd() == null;
        return super.setStart(newStartPoint);
    }

    @Override
    public IRangedSearchFilter setEnd(Calendar newEndPoint) {
        this.allDay = this.getStart() == null && newEndPoint == null;
        return super.setEnd(newEndPoint);
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
        if (allDay) {
            super.setStart(null);
            super.setEnd(null);
        }
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setInclusive(boolean isInclusive) {
        this.inclusive = isInclusive;
    }

    public String getDisplayableTime() {
        if (!this.hasSearchValue()) {
            return "";
        }
        DateFormat format = DateTimeUtils.getSimpleTimeFormat();
        Date from = ((Calendar)this.getStart()).getTime();
        Date to = ((Calendar)this.getEnd()).getTime();
        StringBuilder SB = new StringBuilder();
        if (this.dayPart != null && this.dayPart.equalsTimeRange(from, to)) {
            SB.append(this.dayPart.getLabel()).append(": ");
        }
        SB.append(format.format(((Calendar)this.getStart()).getTime())).append(" - ").append(format.format(((Calendar)this.getEnd()).getTime())).toString();
        return SB.toString();
    }

    public void setDayPart(DayPart selectedDayPart) {
        this.dayPart = selectedDayPart;
        if (this.dayPart != null) {
            this.setStart(DateTimeUtils.getCalendar(this.dayPart.getStartTime()));
            this.setEnd(DateTimeUtils.getCalendar(this.dayPart.getEndTime()));
        }
    }

    public boolean isSupportCrossDay() {
        return this.isSupportCrossDay;
    }

    public void setSupportCrossDay(boolean isSupportCrossDay) {
        this.isSupportCrossDay = isSupportCrossDay;
    }
}

