/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.loyalty;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.HOMimic;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="Earn")
@AccessType(value="property")
public class EarningLoyaltyPointTransaction
extends LoyaltyPointTransaction {
    public static final Props Properties = new Props();
    @HOMimic(mimic="salesRef", clazz=LoyaltyPointTransaction.class)
    private Reference<SalesComponent> salesComponent;

    public EarningLoyaltyPointTransaction() {
        this.salesComponent = this.createReference(EarningLoyaltyPointTransaction.Properties.SALES_COMPONENT);
    }

    EarningLoyaltyPointTransaction(Customer customer, int pointsEarnt, EventContext context, SalesComponent component, Long permitNumber) {
        super(customer, pointsEarnt, context, permitNumber);
        this.salesComponent = this.createReference(EarningLoyaltyPointTransaction.Properties.SALES_COMPONENT);
        this.setSalesComponent(component);
        this.updateDollarValue();
    }

    @Transient
    public SalesComponent getSalesComponent() {
        return this.salesComponent.get();
    }

    protected void setSalesComponent(SalesComponent newComponent) {
        this.salesComponent.set(newComponent);
        if (newComponent != null) {
            this.salesRef = newComponent.getID();
        }
    }

    @Column(name="fk_sales_component")
    public Long getSalesRef() {
        return this.salesRef;
    }

    protected void setSalesRef(Long value) {
        this.salesRef = value;
    }

    @Override
    public void updateDollarValue() {
        if (!this.salesComponent.isNull()) {
            this.setDollarValue(this.getSalesComponent().getTotalPrice());
        } else {
            this.setDollarValue(null);
        }
    }

    @Override
    @Transient
    public LoyaltyPointTransaction.LoyTransDirectionType getDirection() {
        return LoyaltyPointTransaction.LoyTransDirectionType.EARN;
    }

    public static final class Props
    extends LoyaltyPointTransaction.Props {
        public PropertiedObject.Property<SalesComponent> SALES_COMPONENT;
    }
}

