/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.loyalty;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.LoyaltyPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerPoints;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.loyalty.EarningLoyaltyPointTransaction;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;
import ordermate.database.sales.loyalty.RedeemingLoyaltyPointTransaction;
import ordermate.integration.loyalty.LoyaltyPointAuthority;
import ordermate.integration.loyalty.LoyaltyPointsInfoRecord;

public final class LoyaltyPointAdministrator {
    private static LoyaltyPointAdministrator administrator = new LoyaltyPointAdministrator();
    private final Object earningMutex = new Object();
    private LoyaltyPointAuthority authority;

    private LoyaltyPointAdministrator() {
    }

    public static final LoyaltyPointAdministrator getInstance() {
        return administrator;
    }

    public void setAuthority(LoyaltyPointAuthority theAuthority) {
        this.authority = theAuthority;
    }

    public final void earnLoyaltyPoints(Account account, final EventContext context) {
        if (!SystemProperty.getInstance().isLoyaltyEnabled()) {
            return;
        }
        if (account.isOpen()) {
            throw new IllegalArgumentException("Cannot earn loyalty points on open account :" + account);
        }
        final Customer customer = account.getCustomer();
        if (customer == null || !customer.isPersistent()) {
            OrderMate.LOG.info("Cannot add loyalty point transaction to an itemgroup without a customer.");
            return;
        }
        if (customer.getCategory() != null && !customer.getCategory().isLoyaltyPointsEnabled()) {
            return;
        }
        final ArrayList<SalesLineItem> items = new ArrayList<SalesLineItem>(account.getItems());
        for (SalesLineItem line : items) {
            for (SalesItem item : line.getSalesItems()) {
                for (SalesComponent comp : item.getComponentList()) {
                    comp.getHelper().calculateLoyalty(null, comp.getPriceLevel());
                }
            }
        }
        Thread runner = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet<Customer> allCustomersWithPoints = new HashSet<Customer>();
                allCustomersWithPoints.add(customer);
                Object object = LoyaltyPointAdministrator.this.earningMutex;
                synchronized (object) {
                    for (SalesLineItem nextLineItem : items) {
                        Long permit = null;
                        Customer actualCustomer = nextLineItem.getCustomer();
                        if (actualCustomer == null || actualCustomer.equals(customer)) {
                            actualCustomer = customer;
                        } else {
                            allCustomersWithPoints.add(actualCustomer);
                        }
                        if (LoyaltyPointAdministrator.this.authority != null) {
                            int numPoints = nextLineItem.getLoyaltyPointsCount();
                            permit = LoyaltyPointAdministrator.this.authority.accruePoints(new LoyaltyPointsInfoRecord(actualCustomer, numPoints, context));
                        }
                        LoyaltyPointAdministrator.this.createEarningLoyaltyPointTxn(nextLineItem, actualCustomer, context, permit);
                        nextLineItem.markLoyaltyPointsTaken();
                        if (!nextLineItem.isPersistent()) {
                            for (int attempt = 0; !nextLineItem.isPersistent() && attempt < 10; ++attempt) {
                                try {
                                    Thread.sleep(100L);
                                    continue;
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (!nextLineItem.isPersistent()) continue;
                        PersistenceManager.saveChild(nextLineItem);
                    }
                    Iterator iterator = allCustomersWithPoints.iterator();
                    while (iterator.hasNext()) {
                        Customer custToSave;
                        Customer customer2 = custToSave = (Customer)iterator.next();
                        synchronized (customer2) {
                            custToSave.save();
                        }
                    }
                }
            }
        });
        runner.start();
    }

    private final Set<EarningLoyaltyPointTransaction> createEarningLoyaltyPointTxn(SalesLineItem item, Customer cust, EventContext context, Long permitNumber) {
        HashSet<EarningLoyaltyPointTransaction> txns = new HashSet<EarningLoyaltyPointTransaction>();
        for (SalesItem nextItem : item.getSalesItems()) {
            if (!nextItem.hasLoyaltyPointsAvailable()) continue;
            for (SalesComponent nextComp : nextItem.getComponentList()) {
                if (nextComp.isLoyaltyRedeemed()) continue;
                int points = (int)Math.floor((double)nextComp.getMenuLoyaltyAdd() * nextItem.getQuantity().getValue().doubleValue());
                if (nextComp.getLoyaltyPointTransaction() != null) {
                    throw new IllegalStateException("Points have already been earnt for this component" + nextComp + " with transaction  " + nextComp.getLoyaltyPointTransaction());
                }
                if (points == 0) continue;
                Customer customer = cust;
                if (customer == null) {
                    customer = item.getCustomer();
                }
                EarningLoyaltyPointTransaction txn = new EarningLoyaltyPointTransaction(customer, points, context, nextComp, permitNumber);
                nextComp.setLoyaltyPointTransaction(txn);
                customer.loyaltyPointTransactionAdded(txn);
                txns.add(txn);
                this.logLoyalty(txn);
            }
        }
        return txns;
    }

    public final boolean redeemLoyaltyPoints(SalesLineItem itemToRedeem, Customer customer, EventContext context) {
        if (!SystemProperty.getInstance().isLoyaltyEnabled()) {
            OrderMate.LOG.error("Cannot set loyalty points, Loyalty is not enabled");
            return false;
        }
        if (customer == null || !customer.isPersistent()) {
            OrderMate.LOG.warn("Cannot redeem loyalty points if customer is not set.");
            return false;
        }
        if (customer.getCategory() != null && !customer.getCategory().isLoyaltyPointsEnabled()) {
            OrderMate.LOG.warn("Cannot redeem loyalty points Customer Category does not allow it.");
            return false;
        }
        Long permitNumber = null;
        int numPoints = -itemToRedeem.getLoyaltyPointsCost();
        if (this.authority != null) {
            permitNumber = this.authority.redeemPoints(new LoyaltyPointsInfoRecord(customer, numPoints, this.getPersistentID(itemToRedeem), context));
            if (permitNumber == null) {
                this.updatePointsForCustomer(customer);
                return false;
            }
        } else if (customer.getLoyaltyPoints() < -numPoints) {
            return false;
        }
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        loyaltyAdj.createSalesPriceAdjustment(itemToRedeem.getSalesItems(), context);
        for (SalesItem nextItem : itemToRedeem.getSalesItems()) {
            SalesPriceAdjustment nextAdj = nextItem.getPriceAdjustment(loyaltyAdj);
            for (SalesComponent nextComp : nextItem.getComponentList()) {
                this.createRedeemingLoyaltyPointTxn(nextComp.getPriceAdjustmentUsage(nextAdj, context), customer, context, permitNumber);
            }
        }
        itemToRedeem.markAsLoyaltyPointsRedeemed();
        return true;
    }

    private final RedeemingLoyaltyPointTransaction createRedeemingLoyaltyPointTxn(SalesPriceAdjustmentUsage usage, Customer customer, EventContext context, Long permitNumber) {
        SalesComponent component = usage.getSalesComponent();
        if (component.getPriceLevel().isForceLoyaltyFactor()) {
            component.getHelper().calculateLoyalty(null, component.getPriceLevel());
        }
        RedeemingLoyaltyPointTransaction txn = new RedeemingLoyaltyPointTransaction(customer, -1 * (int)Math.ceil((double)Math.abs(component.getMenuLoyaltyRedeem()) * component.getSalesItem().getQuantity().getValue().doubleValue()), context, usage, permitNumber);
        usage.addLoyaltyPointTransaction(txn);
        customer.loyaltyPointTransactionAdded(txn);
        this.logLoyalty(txn);
        return txn;
    }

    public final boolean setLoyaltyPoints(Customer customer, int newPoints, EventContext context) {
        if (!SystemProperty.getInstance().isLoyaltyEnabled()) {
            OrderMate.LOG.error("Cannot set loyalty points, Loyalty is not enabled");
            return false;
        }
        boolean isHOEnabled = HOConfig.getInstance().isEnabled();
        Long permitNumber = null;
        if (isHOEnabled && !this.updatePointsForCustomer(customer)) {
            return false;
        }
        int changePoints = newPoints - customer.getLoyaltyPoints();
        if (this.authority != null && isHOEnabled && (permitNumber = this.authority.setResetNumberOfPoints(new LoyaltyPointsInfoRecord(customer, changePoints, context))) == null) {
            return false;
        }
        this.createAdjustingTransaction(customer, changePoints, permitNumber, context);
        return true;
    }

    public void createAdjustingTransaction(Customer customer, int changePoints, Long permitNumber, EventContext context) {
        LoyaltyPointTransaction changePointsTxn = null;
        if (changePoints > 0) {
            changePointsTxn = new EarningLoyaltyPointTransaction(customer, changePoints, context, null, permitNumber);
        } else if (changePoints < 0) {
            changePointsTxn = new RedeemingLoyaltyPointTransaction(customer, changePoints, context, null, permitNumber);
        }
        if (changePointsTxn != null) {
            this.logLoyalty(changePointsTxn);
            customer.loyaltyPointTransactionAdded(changePointsTxn);
            customer.save();
            changePointsTxn.saveChild();
        }
    }

    public boolean updatePointsForCustomer(Customer customer) {
        if (this.authority == null) {
            return this.resynchPointsForCustomer(customer);
        }
        Integer points = this.authority.updateNumberOfPoints(new LoyaltyPointsInfoRecord(customer));
        if (points != null) {
            customer.ensureHasPoints();
            customer.getCustomerPoints().setTotalPoints(points);
            customer.getCustomerPoints().save();
        }
        return points != null;
    }

    public boolean resynchPointsForCustomer(Customer customer) {
        if (this.authority != null) {
            if (this.authority.resyncPoints(new LoyaltyPointsInfoRecord(customer))) {
                return this.updatePointsForCustomer(customer);
            }
            return false;
        }
        customer.ensureHasPoints();
        ObjectQuery query = Query.sum(LoyaltyPointTransaction.Properties.AMOUNT).equals(LoyaltyPointTransaction.Properties.CUSTOMER, customer).active(LoyaltyPointTransaction.class);
        Object[][] tally = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
        if (tally != null && tally.length > 0 && tally[0].length > 0) {
            CustomerPoints points = customer.getCustomerPoints();
            if (tally[0][0] == null) {
                points.setTotalPoints(0);
            } else {
                points.setTotalPoints(((Number)tally[0][0]).intValue());
            }
            return true;
        }
        return false;
    }

    private final void logLoyalty(LoyaltyPointTransaction txn) {
        StringBuilder SB = new StringBuilder();
        int amount = txn.getAmount();
        if (amount > 0) {
            SB.append("Points earnt ");
        } else {
            SB.append("Points redeemed ");
        }
        SB.append(amount).append(" added to ");
        SB.append(txn.getCustomer().getName()).append(" by User ").append(txn.getUser()).append(" on Terminal ").append(txn.getTerminal()).append(" on shift ").append(txn.getShift());
        OrderMate.LOG.info(SB.toString());
    }

    public void usageRemoved(SalesPriceAdjustmentUsage usage) {
        if (!SystemProperty.getInstance().isLoyaltyEnabled()) {
            return;
        }
        ArrayList<RedeemingLoyaltyPointTransaction> txns = new ArrayList<RedeemingLoyaltyPointTransaction>(usage.getLoyaltyPointTransactions());
        HashMap<Customer, Integer> pointsMap = null;
        pointsMap = new HashMap<Customer, Integer>();
        for (RedeemingLoyaltyPointTransaction nextTxn : txns) {
            Customer customer = nextTxn.getCustomer();
            customer.loyaltyPointTransactionRemoved(nextTxn);
            if (SystemState.ACTIVE_STATE.equals(nextTxn.getSystemState())) {
                nextTxn.setSystemState(SystemState.DELETED_STATE);
                nextTxn.saveChild();
                if (!pointsMap.containsKey(customer)) {
                    pointsMap.put(customer, nextTxn.getAmount());
                } else {
                    pointsMap.put(customer, nextTxn.getAmount() + (Integer)pointsMap.get(customer));
                }
            }
            if (usage.getSalesComponent() == null) continue;
            usage.getSalesComponent().getSalesItem().markAsLoyaltyPointsNotRedeemed();
        }
        for (Customer customer : pointsMap.keySet()) {
            customer.save();
            int value = (Integer)pointsMap.get(customer);
            if (value == 0 || this.authority == null || this.authority.returnRedeemedPoints(new LoyaltyPointsInfoRecord(customer, value, "UR" + this.getPersistentID(usage))) || this.authority.getGuiHandler() == null) continue;
            StringBuilder SB = new StringBuilder("<html><b>Head Office cannot be contacted</b>");
            SB.append("<br><br>The Loyalty Points returned may not be made available until<br>");
            SB.append("the next working day.</html>");
            this.authority.getGuiHandler().displayOkDialog("Cannot contact Head Office", SB.toString());
        }
    }

    public void salesLineItemRemoved(SalesLineItem lineItem, EventContext context) {
        if (!SystemProperty.getInstance().isLoyaltyEnabled()) {
            return;
        }
        if (lineItem.getCustomer() == null || !lineItem.getCustomer().isPersistent()) {
            OrderMate.LOG.warn("Cannot redeem loyalty points if customer is not set.");
            return;
        }
        int pointsToReturn = 0;
        for (SalesItem item : lineItem.getSalesItems()) {
            for (SalesComponent nextComponent : item.getComponentList()) {
                for (SalesPriceAdjustmentUsage usage : nextComponent.getPriceAdjustmentUsages()) {
                    this.usageRemoved(usage);
                }
            }
            List<EarningLoyaltyPointTransaction> txns = PersistenceManager.getObjectList(EarningLoyaltyPointTransaction.class, Query.select(EarningLoyaltyPointTransaction.class).active(EarningLoyaltyPointTransaction.class).wherePropertyIn(EarningLoyaltyPointTransaction.Properties.SALES_COMPONENT, item.getComponentList()).toString(), null);
            for (EarningLoyaltyPointTransaction nextTxn : txns) {
                pointsToReturn += nextTxn.getAmount();
                nextTxn.getCustomer().loyaltyPointTransactionRemoved(nextTxn);
                nextTxn.setSystemState(SystemState.DELETED_STATE);
                nextTxn.saveChild();
                nextTxn.getCustomer().save();
            }
            item.markAsLoyaltyPointsNotRedeemed();
        }
        if (this.authority != null) {
            if (pointsToReturn == 0) {
                OrderMate.LOG.info("LoyaltyPointAdministrator: No accrued points to return.");
            } else {
                this.authority.returnAccruedPoints(new LoyaltyPointsInfoRecord(lineItem.getCustomer(), pointsToReturn, "IR" + this.getPersistentID(lineItem), context));
            }
        }
    }

    public void itemsMoved(List<SalesLineItem> oldItems, List<SalesLineItem> newItems) {
        if (!SystemProperty.getInstance().isLoyaltyEnabled()) {
            return;
        }
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        HashSet<SalesLineItem> items = new HashSet<SalesLineItem>();
        for (SalesLineItem lineItem : oldItems) {
            for (SalesPriceAdjustment adj : lineItem.getPriceAdjustments()) {
                if (!loyaltyAdj.equals(adj.getInventoryPriceAdjustment())) continue;
                items.add(lineItem);
            }
        }
        block2: for (SalesLineItem oldLineItem : items) {
            for (SalesLineItem newLineItem : newItems) {
                if (!oldLineItem.isEquivalentTo(newLineItem, true, true)) continue;
                this.transferLoyaltyPointTransactions(oldLineItem, newLineItem);
                continue block2;
            }
        }
    }

    private void transferLoyaltyPointTransactions(SalesLineItem oldLineItem, SalesLineItem newLineItem) {
        for (SalesItem oldItem : oldLineItem.getSalesItems()) {
            for (SalesItem newItem : newLineItem.getSalesItems()) {
                block2: for (SalesComponent oldComp : oldItem.getComponentList()) {
                    for (SalesComponent newComp : newItem.getComponentList()) {
                        if (!oldComp.isEquivalentTo(newComp, true)) continue;
                        this.replaceUsage(oldComp, newComp);
                        continue block2;
                    }
                }
            }
        }
    }

    private void replaceUsage(SalesComponent oldComp, SalesComponent newComp) {
        for (SalesPriceAdjustmentUsage oldUsage : oldComp.getPriceAdjustmentUsages()) {
            for (SalesPriceAdjustmentUsage newUsage : newComp.getPriceAdjustmentUsages()) {
                for (RedeemingLoyaltyPointTransaction txn : oldUsage.getLoyaltyPointTransactions()) {
                    if (!SystemState.ACTIVE_STATE.equals(txn.getSystemState())) continue;
                    RedeemingLoyaltyPointTransaction newTxn = this.replaceUsageWith(txn, newUsage);
                    newUsage.addLoyaltyPointTransaction(newTxn);
                    txn.getCustomer().loyaltyPointTransactionRemoved(txn);
                    txn.setSystemState(SystemState.DELETED_STATE);
                    txn.getCustomer().loyaltyPointTransactionAdded(newTxn);
                }
            }
        }
    }

    public void unapplyLoyaltyPointRedemptionDiscounts(Set<SalesLineItem> removedRedemptions, EventContext context) {
        HashMap<Customer, Integer> pointsMap = null;
        if (this.authority != null) {
            pointsMap = new HashMap<Customer, Integer>();
        }
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        for (SalesLineItem nextItem : removedRedemptions) {
            SalesPriceAdjustment toRemove = null;
            for (SalesPriceAdjustment adj : nextItem.getPriceAdjustments()) {
                if (!loyaltyAdj.equals(adj.getInventoryPriceAdjustment())) continue;
                toRemove = adj;
                break;
            }
            if (toRemove == null) continue;
            nextItem.removePriceAdjustment(toRemove, context);
            if (pointsMap == null) continue;
            Customer customer = nextItem.getCustomer();
            if (!pointsMap.containsKey(customer)) {
                pointsMap.put(customer, -nextItem.getLoyaltyPointsCost());
                continue;
            }
            pointsMap.put(customer, (Integer)pointsMap.get(customer) - nextItem.getLoyaltyPointsCost());
        }
    }

    private RedeemingLoyaltyPointTransaction replaceUsageWith(RedeemingLoyaltyPointTransaction txn, SalesPriceAdjustmentUsage usage) {
        return new RedeemingLoyaltyPointTransaction(txn.getCustomer(), txn.getAmount(), new EventContext(txn.getTerminal(), txn.getUser(), null, txn.getShift()), usage, txn.getPermitNumber());
    }

    public final List<SalesLineItem> getAffordableRedeemableItems(ItemGroup group, int pointsAvailable) {
        int tempPoints = 0;
        if (pointsAvailable == 0) {
            return Collections.emptyList();
        }
        if (!group.hasCustomer()) {
            return Collections.emptyList();
        }
        List<SalesLineItem> items = this.getAllRedeemableItems(group, Integer.MAX_VALUE);
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SalesLineItem> affordableItems = new ArrayList<SalesLineItem>();
        Iterator<SalesLineItem> it = items.iterator();
        tempPoints = pointsAvailable;
        while (it.hasNext()) {
            SalesLineItem currentItem = it.next();
            if (!this.isRedeemable(currentItem, tempPoints) || !currentItem.hasLoyaltyPointsAvailable()) continue;
            affordableItems.add(currentItem);
            tempPoints -= currentItem.getLoyaltyPointsCost();
        }
        return affordableItems;
    }

    public final List<SalesLineItem> getAllRedeemableItems(ItemGroup group, int limit) {
        List<SalesLineItem> items = group.getItems();
        ArrayList<SalesLineItem> redeemableItems = new ArrayList<SalesLineItem>();
        for (SalesLineItem currentItem : items) {
            if (!this.isRedeemable(currentItem, limit)) continue;
            redeemableItems.add(currentItem);
        }
        return redeemableItems;
    }

    public final boolean isLoyaltyPossible(ItemGroup group, int points) {
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        for (SalesLineItem lineItem : group.getItems()) {
            for (SalesItem item : lineItem.getSalesItems()) {
                if (item.getPriceAdjustment(loyaltyAdj) == null) continue;
                return true;
            }
        }
        for (SalesLineItem currentItem : group.getItems()) {
            if (!this.isRedeemable(currentItem, points)) continue;
            return true;
        }
        return false;
    }

    private boolean isRedeemable(SalesLineItem lineItem, int points) {
        int adjItemQty = lineItem.getQuantity().getValue().intValue() > 0 ? lineItem.getQuantity().getValue().intValue() : 1;
        return lineItem.getLoyaltyPointsCost() > 0 && lineItem.hasLoyaltyPointsAvailable() && lineItem.getLoyaltyPointsCost() / adjItemQty <= points;
    }

    public List<SalesLineItem> getAllRedeemedItems(ItemGroup itemGroup) {
        List<SalesLineItem> items = itemGroup.getItems();
        ArrayList<SalesLineItem> redeemedItems = new ArrayList<SalesLineItem>();
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        block0: for (SalesLineItem item : items) {
            for (SalesPriceAdjustment adj : item.getPriceAdjustments()) {
                if (!loyaltyAdj.equals(adj.getInventoryPriceAdjustment())) continue;
                redeemedItems.add(item);
                continue block0;
            }
        }
        return redeemedItems;
    }

    public boolean isAtLeastOneLoyaltyRedemption(ItemGroup group) {
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        for (SalesLineItem lineItem : group.getItems()) {
            for (SalesItem item : lineItem.getSalesItems()) {
                if (item.getPriceAdjustment(loyaltyAdj) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void itemSplit(SalesLineItem salesLineItem, SalesLineItem splitLineItem, EventContext context) {
        if (!SystemProperty.getInstance().isLoyaltyEnabled()) {
            return;
        }
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        SalesPriceAdjustment adjustment = null;
        for (SalesPriceAdjustment salesPriceAdjustment : salesLineItem.getPriceAdjustments()) {
            if (!loyaltyAdj.equals(salesPriceAdjustment.getInventoryPriceAdjustment())) continue;
            adjustment = salesPriceAdjustment;
            break;
        }
        if (adjustment != null) {
            List<RedeemingLoyaltyPointTransaction> txns = PersistenceManager.getObjectList(RedeemingLoyaltyPointTransaction.class, Query.select(RedeemingLoyaltyPointTransaction.class).wherePropertyIn(RedeemingLoyaltyPointTransaction.Properties.SALES_PRICE_ADJUSTMENT_USAGE, adjustment.getPriceAdjustmentUsages()).toString(), null);
            this.splitRedeemingTransactions(txns, salesLineItem, splitLineItem, context);
            return;
        }
        if (!salesLineItem.hasLoyaltyPointsAvailable()) {
            HashSet<SalesComponent> components = new HashSet<SalesComponent>();
            for (SalesItem item : salesLineItem.getSalesItems()) {
                components.addAll(item.getComponentList());
            }
            List<EarningLoyaltyPointTransaction> list = PersistenceManager.getObjectList(EarningLoyaltyPointTransaction.class, Query.select(EarningLoyaltyPointTransaction.class).wherePropertyIn(EarningLoyaltyPointTransaction.Properties.SALES_COMPONENT, components).toString(), null);
            this.splitEarningTransactions(list, salesLineItem, splitLineItem, context);
        }
    }

    private void splitRedeemingTransactions(Collection<RedeemingLoyaltyPointTransaction> txns, SalesLineItem oldLineItem, SalesLineItem splitLineItem, EventContext context) {
        Long permitNumber = null;
        for (RedeemingLoyaltyPointTransaction txn : txns) {
            txn.getCustomer().loyaltyPointTransactionRemoved(txn);
            SalesComponent component = txn.getSalesPriceAdjustmentUsage().getSalesComponent();
            int newQuantity = oldLineItem.getQuantity().getValue().intValue();
            txn.setAmount(-1 * Math.abs(component.getMenuLoyaltyRedeem()) * newQuantity);
            txn.setDollarValue(txn.getSalesPriceAdjustmentUsage().getUnitValue().multiply(newQuantity));
            permitNumber = txn.getPermitNumber();
            if (!txn.isPersistent()) continue;
            txn.saveChild();
        }
        LoyaltyPriceAdjustment loyaltyAdj = PriceAdjustmentFactory.getInstance().getLoyaltyRedemptionAdjustment();
        for (SalesItem nextItem : splitLineItem.getSalesItems()) {
            SalesPriceAdjustment nextAdj = nextItem.getPriceAdjustment(loyaltyAdj);
            for (SalesComponent nextComp : nextItem.getComponentList()) {
                RedeemingLoyaltyPointTransaction txn = this.createRedeemingLoyaltyPointTxn(nextComp.getPriceAdjustmentUsage(nextAdj, context), nextItem.getCustomer(), context, permitNumber);
                txn.getCustomer().loyaltyPointTransactionRemoved(txn);
                txn.saveChild();
            }
        }
    }

    private void splitEarningTransactions(Collection<EarningLoyaltyPointTransaction> txns, SalesLineItem oldLineItem, SalesLineItem splitLineItem, EventContext context) {
        Long permitNumber = null;
        for (EarningLoyaltyPointTransaction txn : txns) {
            txn.getCustomer().loyaltyPointTransactionRemoved(txn);
            SalesComponent component = txn.getSalesComponent();
            txn.setAmount((int)Math.floor(component.getMenuLoyaltyAdd() * oldLineItem.getQuantity().getValue().intValue()));
            txn.updateDollarValue();
            permitNumber = txn.getPermitNumber();
            if (!txn.isPersistent()) continue;
            txn.saveChild();
        }
        splitLineItem.markAsLoyaltyPointsNotRedeemed();
        Set<EarningLoyaltyPointTransaction> newTxns = this.createEarningLoyaltyPointTxn(splitLineItem, splitLineItem.getCustomer(), context, permitNumber);
        for (EarningLoyaltyPointTransaction txn : newTxns) {
            txn.getCustomer().loyaltyPointTransactionRemoved(txn);
        }
    }

    private String getPersistentID(PersistentObject persistentObj) {
        String result = "";
        if (persistentObj.isPersistent()) {
            result = persistentObj.getID().toString();
        }
        return result;
    }

    public Customer fetchCustomerInfoFromAuthority(String custCardNo, String email) {
        if (this.authority != null) {
            Customer dummyCustomer = new Customer();
            dummyCustomer.setCardID(custCardNo);
            dummyCustomer.setEmail(email);
            LoyaltyPointsInfoRecord loyPointsRecord = new LoyaltyPointsInfoRecord(dummyCustomer);
            if (this.authority.fetchCustomerInfo(loyPointsRecord)) {
                loyPointsRecord.getCustomer().ensureHasPoints();
                CustomerPoints cusPoints = loyPointsRecord.getCustomer().getCustomerPoints();
                cusPoints.setTotalPoints(loyPointsRecord.getNumPoints());
                if (loyPointsRecord.getCustomer().getCategory() == null) {
                    loyPointsRecord.getCustomer().setCategory(CustomerCategory.getDefaultCategory());
                }
                loyPointsRecord.getCustomer().save();
                return loyPointsRecord.getCustomer();
            }
        }
        return null;
    }

    public Customer updateCustomerInfoFromAuthority(Customer cust) {
        LoyaltyPointsInfoRecord loyPointsRecord;
        if (this.authority != null && this.authority.updateCustomerInfo(loyPointsRecord = new LoyaltyPointsInfoRecord(cust))) {
            cust.save();
            CustomerPoints cusPoints = cust.getCustomerPoints();
            cusPoints.setTotalPoints(loyPointsRecord.getNumPoints());
            cusPoints.save();
        }
        return cust;
    }
}

