/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.loyalty;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.HOMimic;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Customer;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sales_loyalty_point_transaction")
@DiscriminatorColumn(name="direction")
@AccessType(value="property")
public abstract class LoyaltyPointTransaction
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Reference<Customer> customer;
    private int amount;
    private Price dollarValue;
    private Date datetime;
    private Long permitNumber;
    @HOMimic(mimic="userRef", clazz=LoyaltyPointTransaction.class)
    private Reference<User> user;
    @HOMimic(mimic="terminalRef", clazz=LoyaltyPointTransaction.class)
    private Reference<Terminal> terminal;
    @HOMimic(mimic="shiftRef", clazz=LoyaltyPointTransaction.class)
    private Reference<Shift> shift;
    private Long userRef;
    private Long terminalRef;
    private Long shiftRef;
    protected Long salesRef;

    public LoyaltyPointTransaction() {
        this.customer = this.createReference(LoyaltyPointTransaction.Properties.CUSTOMER);
        this.user = this.createReference(LoyaltyPointTransaction.Properties.USER);
        this.terminal = this.createReference(LoyaltyPointTransaction.Properties.TERMINAL);
        this.shift = this.createReference(LoyaltyPointTransaction.Properties.SHIFT);
    }

    LoyaltyPointTransaction(Customer newCustomer, int newAmount, EventContext newContext, Long permitNumber) {
        this.customer = this.createReference(LoyaltyPointTransaction.Properties.CUSTOMER);
        this.user = this.createReference(LoyaltyPointTransaction.Properties.USER);
        this.terminal = this.createReference(LoyaltyPointTransaction.Properties.TERMINAL);
        this.shift = this.createReference(LoyaltyPointTransaction.Properties.SHIFT);
        this.setCustomer(newCustomer);
        this.setAmount(newAmount);
        this.setTerminal(newContext.getTerminal());
        this.setUser(newContext.getUser());
        this.setShift(newContext.getShift());
        this.setDatetime(new Date());
        this.setPermitNumber(permitNumber);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState newState) {
        this.systemState = newState;
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_customer")
    public Customer getCustomer() {
        return this.customer.get();
    }

    private void setCustomer(Customer value) {
        this.customer.set(value);
    }

    @Column(name="amount")
    public int getAmount() {
        return this.amount;
    }

    protected void setAmount(int value) {
        this.amount = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="dollar_value")
    public Price getDollarValue() {
        return this.dollarValue;
    }

    protected void setDollarValue(Price newDollarValue) {
        this.dollarValue = newDollarValue;
    }

    @Transient
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    protected void setTerminal(Terminal newTerminal) {
        this.terminal.set(newTerminal);
        if (newTerminal != null) {
            this.terminalRef = newTerminal.getID();
        }
    }

    @Column(name="FK_config_terminal")
    public Long getTerminalRef() {
        return this.terminalRef;
    }

    protected void setTerminalRef(Long value) {
        this.terminalRef = value;
    }

    @Transient
    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User newUser) {
        this.user.set(newUser);
        if (newUser != null) {
            this.userRef = newUser.getID();
        }
    }

    @Column(name="FK_config_user")
    public Long getUserRef() {
        return this.userRef;
    }

    protected void setUserRef(Long value) {
        this.userRef = value;
    }

    protected void setShift(Shift newShift) {
        this.shift.set(newShift);
        if (newShift != null) {
            this.shiftRef = newShift.getID();
        }
    }

    @Transient
    public Shift getShift() {
        return this.shift.get();
    }

    @Column(name="fk_config_shift")
    public Long getShiftRef() {
        return this.shiftRef;
    }

    protected void setShiftRef(Long value) {
        this.shiftRef = value;
    }

    @Column(name="datetime")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDatetime() {
        return this.datetime;
    }

    @Transient
    public String getDatetimeString() {
        if (this.getDatetime() != null) {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
            return format.format(this.getDatetime());
        }
        return "No Date";
    }

    @Column(name="permit_number")
    public Long getPermitNumber() {
        return this.permitNumber;
    }

    protected void setPermitNumber(Long thePermitNumber) {
        this.permitNumber = thePermitNumber;
    }

    protected void setDatetime(Date newDatetime) {
        this.datetime = newDatetime;
    }

    @Transient
    public boolean isManualAdjustment() {
        return this.salesRef == null;
    }

    abstract void updateDollarValue();

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Transient
    public abstract LoyTransDirectionType getDirection();

    public static enum LoyTransDirectionType {
        EARN,
        REDEEM;

    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property AMOUNT;
        public PropertiedObject.Property<Price> DOLLAR_VALUE;
        public PropertiedObject.Property<Date> DATETIME;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<Long> PERMIT_NUMBER;
        public PersistentObject.DerivedProperty MANUAL_ADJUSTMENT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)LoyaltyPointTransaction.class), "manualAdjustment");
        public PersistentObject.DerivedProperty<LoyTransDirectionType> DIRECTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)LoyaltyPointTransaction.class), "direction");
        public final PersistentObject.DerivedProperty<String> DATETIME_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)LoyaltyPointTransaction.class), "datetimeString");
    }
}

