/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.loyalty;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.HOMimic;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="Redeem")
@AccessType(value="property")
public class RedeemingLoyaltyPointTransaction
extends LoyaltyPointTransaction {
    public static final Props Properties = new Props();
    @HOMimic(mimic="salesRef", clazz=LoyaltyPointTransaction.class)
    private Reference<SalesPriceAdjustmentUsage> salesPriceAdjustmentUsage;

    public RedeemingLoyaltyPointTransaction() {
        this.salesPriceAdjustmentUsage = this.createReference(RedeemingLoyaltyPointTransaction.Properties.SALES_PRICE_ADJUSTMENT_USAGE);
    }

    @Override
    public void saveChild() {
        super.saveChild();
    }

    RedeemingLoyaltyPointTransaction(Customer customer, int pointsRedeemed, EventContext context, SalesPriceAdjustmentUsage usage, Long permitNumber) {
        super(customer, pointsRedeemed, context, permitNumber);
        this.salesPriceAdjustmentUsage = this.createReference(RedeemingLoyaltyPointTransaction.Properties.SALES_PRICE_ADJUSTMENT_USAGE);
        this.setSalesPriceAdjustmentUsage(usage);
        this.updateDollarValue();
    }

    @Transient
    public SalesPriceAdjustmentUsage getSalesPriceAdjustmentUsage() {
        return this.salesPriceAdjustmentUsage.get();
    }

    protected void setSalesPriceAdjustmentUsage(SalesPriceAdjustmentUsage newUsage) {
        this.salesPriceAdjustmentUsage.set(newUsage);
        if (newUsage != null) {
            this.salesRef = newUsage.getID();
        }
    }

    @Column(name="fk_sales_price_adjustment_usage")
    public Long getSalesRef() {
        return this.salesRef;
    }

    protected void setSalesRef(Long value) {
        this.salesRef = value;
    }

    @Override
    void updateDollarValue() {
        if (this.getSalesPriceAdjustmentUsage() != null) {
            this.setDollarValue(this.getSalesPriceAdjustmentUsage().getValue());
        } else {
            this.setDollarValue(null);
        }
    }

    @Override
    @Transient
    public LoyaltyPointTransaction.LoyTransDirectionType getDirection() {
        return LoyaltyPointTransaction.LoyTransDirectionType.REDEEM;
    }

    public static final class Props
    extends LoyaltyPointTransaction.Props {
        public PropertiedObject.Property<SalesPriceAdjustmentUsage> SALES_PRICE_ADJUSTMENT_USAGE;
    }
}

