/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.database.sales.printSummary.SummaryGroupingStrategy;

public abstract class AbstractSummaryGroupingStrategy
implements SummaryGroupingStrategy {
    private String identifier;
    private Map<Object, List<SalesItemSummary>> groupMap = new LinkedHashMap<Object, List<SalesItemSummary>>();

    protected AbstractSummaryGroupingStrategy(String theIdentifier) {
        this.identifier = theIdentifier;
    }

    public String toString() {
        return this.identifier;
    }

    protected void putIntoMap(Object groupId, SalesItemSummary summary) {
        List<SalesItemSummary> summaryList = this.groupMap.get(groupId);
        if (summaryList == null) {
            summaryList = new ArrayList<SalesItemSummary>();
            this.groupMap.put(groupId, summaryList);
        }
        summaryList.add(summary);
    }

    protected SalesItemSummaryGroup createNewSummaryGroup(List<SalesItemSummary> summaries, String systemState, Boolean reprinted) {
        SalesItemSummary summary = summaries.get(0);
        String description = summary.getLabel();
        Set<SalesCombo> combos = null;
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesItemSummary nextSummary : summaries) {
            quantity = reprinted == null ? quantity.add(nextSummary.getTotalCommittedQuantity(systemState)) : quantity.add(nextSummary.getTotalCommittedQuantity(reprinted, systemState));
            combos = this.addCombos(nextSummary, combos);
        }
        SalesItemSummaryGroup group = new SalesItemSummaryGroup(summaries, quantity, description, systemState);
        group.setComboQuantity(this.getComboQty(combos, systemState));
        return group;
    }

    private SalesQuantity getComboQty(Set<SalesCombo> combos, String state) {
        SalesQuantity qty = null;
        if (combos != null) {
            qty = SalesQuantity.ZERO;
            for (SalesCombo combo : combos) {
                if (state == null) {
                    qty = combo.getQuantity();
                    continue;
                }
                qty = qty.add(combo.getSavedQuantity(false, state));
            }
        }
        return qty;
    }

    private Set<SalesCombo> addCombos(SalesItemSummary nextSummary, Set<SalesCombo> combos) {
        if (nextSummary.getSalesItem().isComboItem()) {
            if (combos == null) {
                combos = new HashSet<SalesCombo>();
            }
            for (SalesItem nextItem : nextSummary.getSalesItems()) {
                if (nextItem.getParentCombo() == null) continue;
                combos.add(nextItem.getParentCombo());
            }
        }
        return combos;
    }

    protected SalesItemSummaryGroup createNewSummaryGroup(List<SalesItemSummary> summaries, String systemState, Boolean reprinted, boolean itemNameSort) {
        SalesItemSummary summary = summaries.get(0);
        summary.setSortingItemName(itemNameSort);
        String description = summary.getLabel();
        Set<SalesCombo> combos = null;
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (SalesItemSummary nextSummary : summaries) {
            quantity = reprinted == null ? quantity.add(nextSummary.getTotalCommittedQuantity(systemState)) : quantity.add(nextSummary.getTotalCommittedQuantity(reprinted, systemState));
            combos = this.addCombos(nextSummary, combos);
        }
        SalesItemSummaryGroup group = new SalesItemSummaryGroup(summaries, quantity, description, systemState);
        group.setComboQuantity(this.getComboQty(combos, systemState));
        return group;
    }

    protected void initGroupMap(int size) {
        this.groupMap = new LinkedHashMap<Object, List<SalesItemSummary>>((int)((double)size * 1.25) + 1, 0.8f);
    }

    protected Set getSummarySet() {
        return this.groupMap.entrySet();
    }
}

