/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.printSummary.DocketSummary;
import ordermate.database.sales.printSummary.DocketSummaryImpl;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.internationalization.Internationalization;

public class DocketSummaryBuilder {
    private static final String SPACE = " ";
    private static final String STANDARD = "STANDARD";
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private static final int NO_SPACING = 0;
    private static final int PORTIONED_ITEM_WITH_QTY = 3;
    private static final int PORTIONED_ITEM_DEFAULT = 4;
    private static final int DEFAULT_SPACING = 5;
    private static final int STANDARD_ITEM_SPACING = 6;
    private SalesItemSummaryGroup sisg;
    private List<SalesItemSummary> salesItemSummaries;
    private boolean isDeliverable;
    private boolean isReprint;
    private boolean qtyPrinted;

    public DocketSummaryBuilder(SalesItemSummaryGroup salesItemSummaryGroup, boolean isDeliverable, boolean isReprint) {
        this.sisg = salesItemSummaryGroup;
        this.salesItemSummaries = salesItemSummaryGroup.getSummaries();
        this.isDeliverable = isDeliverable;
        this.isReprint = isReprint;
    }

    public List<DocketSummary> buildDocketSummaries() {
        boolean hasNoDecimalQty = true;
        boolean areAllStandard = true;
        for (SalesItemSummary itemSum : this.salesItemSummaries) {
            for (SalesComponent currentComp : this.getSalesComponents(itemSum)) {
                if (!this.checkIfStandardItem(itemSum, currentComp)) {
                    areAllStandard = false;
                }
                if (!this.isDecimalQty(itemSum.getSalesItem().getQuantity())) continue;
                hasNoDecimalQty = false;
            }
        }
        boolean shouldCreateSingleSummary = hasNoDecimalQty && areAllStandard && this.isMultipleStandardSummary();
        return shouldCreateSingleSummary ? Collections.singletonList(this.createSingleSummary()) : this.createGroupedSummaries();
    }

    private DocketSummary createSingleSummary() {
        HashMap<Integer, Integer> totalSeats = new HashMap<Integer, Integer>();
        for (SalesItemSummary itemSum : this.salesItemSummaries) {
            if (!this.ifPrintSeatNumber(itemSum)) continue;
            this.appendSeatsToTotal(totalSeats, itemSum.getSeatNumbersWithCount(this.isReprint, this.getState()));
        }
        DocketSummaryImpl docketSummary = new DocketSummaryImpl();
        docketSummary.setOriginalSummary(this.salesItemSummaries.get(0));
        docketSummary.setSeat(this.totalSeatsMapAsString(totalSeats));
        return docketSummary;
    }

    private List<DocketSummary> createGroupedSummaries() {
        HashMap<String, HashSet<DocketSummary>> groupMapping = this.getGroupedSummaries(this.createUngroupedSummaries());
        ArrayList<DocketSummary> docketSummaries = new ArrayList<DocketSummary>();
        for (HashSet<DocketSummary> group : groupMapping.values()) {
            DocketSummary newSummary = this.combineSummaries(new ArrayList<DocketSummary>(group));
            if (this.isHolderSummary(newSummary)) {
                docketSummaries.addAll(newSummary.getChildSummaries());
                continue;
            }
            docketSummaries.add(newSummary);
            docketSummaries.addAll(newSummary.getChildSummaries());
        }
        return docketSummaries;
    }

    private List<DocketSummary> createUngroupedSummaries() {
        ArrayList<DocketSummary> docketSummaries = new ArrayList<DocketSummary>();
        for (SalesItemSummary itemSum : this.salesItemSummaries) {
            HashMap<Integer, Integer> totalSeats = new HashMap<Integer, Integer>();
            List<SalesComponent> components = this.getSalesComponents(itemSum);
            SalesQuantity salesQty = itemSum.getTotalCommittedQuantity(this.isReprint, this.getState());
            boolean isFirstLine = true;
            DocketSummaryImpl docketSummary = new DocketSummaryImpl();
            docketSummary.setOriginalSummary(itemSum);
            docketSummary.setQuantity(salesQty);
            Iterator<SalesComponent> itComp = components.iterator();
            while (itComp.hasNext()) {
                SalesComponent currentComp = itComp.next();
                if (!this.wholeMeal(currentComp)) {
                    this.buildDocketSummaryGroup(docketSummary, currentComp, isFirstLine);
                } else if (this.checkIfStandardItem(itemSum, currentComp)) {
                    this.buildStandardSummary(docketSummary, currentComp);
                } else {
                    this.buildNonStandardSummary(docketSummary, currentComp);
                }
                if (!itComp.hasNext()) {
                    String notes = itemSum.getNotes();
                    if (notes != null && !notes.isEmpty()) {
                        docketSummary.setNotes(notes);
                        docketSummary.addIdentifier(notes);
                    }
                    if (this.ifPrintSeatNumber(itemSum)) {
                        this.appendSeatsToTotal(totalSeats, itemSum.getSeatNumbersWithCount(this.isReprint, this.getState()));
                        docketSummary.setSeatMapping(totalSeats);
                    }
                }
                docketSummaries.add(docketSummary);
                isFirstLine = false;
            }
        }
        return docketSummaries;
    }

    private void buildStandardSummary(DocketSummaryImpl docketSummary, SalesComponent currentComp) {
        String description = this.getSummariesSize() > 1 ? this.buildStandardDesciption() : this.buildWholeDesciption(docketSummary, currentComp);
        docketSummary.setDescription(description);
    }

    private void buildNonStandardSummary(DocketSummaryImpl docketSummary, SalesComponent currentComp) {
        docketSummary.setDescription(this.buildWholeDesciption(docketSummary, currentComp));
        docketSummary.setOptions(this.buildOptions(docketSummary, currentComp));
        docketSummary.setMinuses(this.buildMinuses(docketSummary, currentComp));
        docketSummary.setPluses(this.buildPluses(docketSummary, currentComp));
    }

    private HashMap<String, HashSet<DocketSummary>> getGroupedSummaries(List<DocketSummary> ungroupedList) {
        LinkedHashMap<String, HashSet<DocketSummary>> sortedMap = new LinkedHashMap<String, HashSet<DocketSummary>>();
        for (DocketSummary summary : ungroupedList) {
            String identifier = this.getSummaryKey(summary);
            if (sortedMap.containsKey(identifier)) {
                sortedMap.get(identifier).add(summary);
                continue;
            }
            HashSet<DocketSummary> set = new HashSet<DocketSummary>();
            set.add(summary);
            sortedMap.put(identifier, set);
        }
        return sortedMap;
    }

    private String getSummaryKey(DocketSummary summary) {
        String identifier;
        if (this.isDecimalQty(summary.getQuantity())) {
            identifier = String.valueOf(summary.hashCode());
        } else {
            List<String> identifiers = summary.getIdentifiers();
            Collections.sort(identifiers);
            identifier = identifiers.toString();
        }
        return identifier;
    }

    private DocketSummary combineSummaries(List<DocketSummary> group) {
        HashMap<Integer, Integer> totalSeats = new HashMap<Integer, Integer>();
        SalesQuantity quantity = SalesQuantity.ZERO;
        for (DocketSummary currentSummary : group) {
            quantity = quantity.add(currentSummary.getQuantity());
            totalSeats.putAll(currentSummary.getSeatMapping());
        }
        DocketSummaryImpl newSummary = this.createConsolidatedSingleSummary(group.get(0), this.totalSeatsMapAsString(totalSeats), quantity.toString());
        return newSummary;
    }

    private DocketSummaryImpl createConsolidatedSingleSummary(DocketSummary baseSummary, String seatCovers, String qty) {
        this.qtyPrinted = false;
        DocketSummaryImpl newSummary = new DocketSummaryImpl();
        int spacing = STANDARD.equals(baseSummary.getDescription()) ? 6 : 0;
        this.setSummaryDetails(baseSummary, newSummary, qty, spacing, 0);
        if (baseSummary.hasChildSummary()) {
            int lastChildIndex = baseSummary.getChildSummaries().size() - 1;
            newSummary.addChildSummaries(baseSummary.getChildSummaries());
            DocketSummaryImpl lastChildSummary = (DocketSummaryImpl)newSummary.getChildSummaries().get(lastChildIndex);
            this.formatPortionedSummaries(newSummary.getChildSummaries(), qty);
            lastChildSummary.setSeat(seatCovers);
            lastChildSummary.setNotes(this.prependQtyToField(qty, 5, 0, baseSummary.getNotes()));
        } else {
            newSummary.setSeat(seatCovers);
            newSummary.setNotes(this.prependQtyToField(qty, 5, 0, baseSummary.getNotes()));
        }
        return newSummary;
    }

    private void formatPortionedSummaries(List<DocketSummary> childSummaries, String qty) {
        this.qtyPrinted = this.shouldPrintQty();
        for (int i = 0; i < childSummaries.size(); ++i) {
            int spaces = this.qtyPrinted ? 4 : 3;
            DocketSummaryImpl summary = (DocketSummaryImpl)childSummaries.get(i);
            this.setSummaryDetails(summary, summary, qty, 0, spaces);
        }
    }

    private void setSummaryDetails(DocketSummary baseSummary, DocketSummaryImpl newSummary, String qty, int spaces, int trailingSpaces) {
        newSummary.setDescription(this.prependQtyToField(qty, spaces, trailingSpaces, baseSummary.getDescription()));
        newSummary.setExtraInfo(this.prependQtyToField(qty, spaces, 0, baseSummary.getExtraInfo()));
        newSummary.setOptions(this.modifyListContents(baseSummary.getOptions(), qty));
        newSummary.setMinuses(this.modifyListContents(baseSummary.getMinuses(), qty));
        newSummary.setPluses(this.modifyListContents(baseSummary.getPluses(), qty));
    }

    private String prependQtyToField(String qty, int spaces, int trailingSpaces, String value) {
        if (value.isEmpty()) {
            return value;
        }
        StringBuilder newValue = new StringBuilder();
        newValue.append(this.getFormattedQty(qty, spaces));
        for (int i = 0; i < trailingSpaces; ++i) {
            newValue.append(SPACE);
        }
        newValue.append(value);
        return newValue.toString();
    }

    private List<String> modifyListContents(List<String> components, String qty) {
        for (String component : components) {
            int currentIndex = components.indexOf(component);
            StringBuilder formatted = new StringBuilder();
            formatted.append(this.getFormattedQty(qty, 5));
            formatted.append(component);
            components.set(currentIndex, formatted.toString());
        }
        return components;
    }

    private boolean isMultipleStandardSummary() {
        return this.getSummariesSize() > 1;
    }

    private boolean isHolderSummary(DocketSummary summary) {
        return summary.hasChildSummary() && summary.getDescription().isEmpty() && summary.getExtraInfo().isEmpty();
    }

    private boolean shouldPrintQty() {
        return this.qtyPrinted || this.isPrintable() && this.isSingleSummary();
    }

    private boolean isSingleSummary() {
        return this.getSummariesSize() == 1;
    }

    private String totalSeatsMapAsString(Map<Integer, Integer> totalSeats) {
        StringBuilder sb = new StringBuilder(SPACE);
        if (totalSeats.keySet().size() > 1) {
            sb.append(Internationalization.getLiteralFor("COVERS") + " (");
        } else {
            sb.append(Internationalization.getLiteralFor("COVER") + " (");
        }
        boolean first = true;
        ArrayList<Integer> sortedSeats = new ArrayList<Integer>(totalSeats.keySet());
        Collections.sort(sortedSeats);
        for (Integer seatNumber : sortedSeats) {
            if (!first) {
                sb.append(',');
            }
            if (seatNumber == 0) {
                sb.append("ALL");
            } else {
                sb.append(seatNumber);
            }
            if (totalSeats.get(seatNumber) > 1) {
                sb.append("x");
                sb.append(totalSeats.get(seatNumber));
            }
            first = false;
        }
        sb.append(')');
        return sb.toString();
    }

    private void appendSeatsToTotal(Map<Integer, Integer> totalSeats, Map<Integer, Integer> seatNumbersWithCountToAdd) {
        for (Integer seatNumberToAdd : seatNumbersWithCountToAdd.keySet()) {
            Integer oldValue = new Integer(0);
            if (totalSeats.containsKey(seatNumberToAdd)) {
                oldValue = totalSeats.get(seatNumberToAdd);
            }
            totalSeats.put(seatNumberToAdd, new Integer(oldValue + seatNumbersWithCountToAdd.get(seatNumberToAdd)));
        }
    }

    private boolean ifPrintSeatNumber(SalesItemSummary summary) {
        return !SystemProperty.getInstance().isDontPrintSeatAllWhenItIsOnlySeatForAnItem() || summary.getSeatNumbers().size() > 1 || !summary.getSeatNumbers().contains(0);
    }

    private boolean checkIfStandardItem(SalesItemSummary currentItemSum, SalesComponent currentComp) {
        return currentComp.getTotalOptionsMinusesAndAdds() < 1 && currentItemSum.getNotes() == null && currentComp.getUnit().getPortion().getSize() == 1.0;
    }

    private boolean isDecimalQty(SalesQuantity qty) {
        return qty.toString().contains(".");
    }

    private String buildStandardDesciption() {
        return STANDARD;
    }

    private List<String> buildPluses(DocketSummaryImpl docketSummary, SalesComponent currentComp) {
        ArrayList<String> adds = new ArrayList<String>();
        for (SalesAdd plus : currentComp.getCurrentPluses()) {
            StringBuilder newLine = new StringBuilder();
            newLine.append(PLUS);
            newLine.append(SPACE);
            if (!plus.getModificationSize().getAbbreviatedName().isEmpty()) {
                newLine.append(plus.getModificationSize().getAbbreviatedName());
                newLine.append(SPACE);
            }
            newLine.append(plus.getLabel());
            adds.add(newLine.toString());
        }
        docketSummary.addIdentifiers(adds);
        return adds;
    }

    private List<String> buildMinuses(DocketSummaryImpl docketSummary, SalesComponent currentComp) {
        ArrayList<String> minuses = new ArrayList<String>();
        for (AbstractSalesRemove minus : currentComp.getCurrentMinuses()) {
            StringBuilder newLine = new StringBuilder();
            newLine.append(MINUS);
            newLine.append(SPACE);
            if (!minus.getModificationSize().getAbbreviatedName().isEmpty()) {
                newLine.append(minus.getModificationSize().getAbbreviatedName());
                newLine.append(SPACE);
            }
            newLine.append(minus.getLabel());
            minuses.add(newLine.toString());
        }
        docketSummary.addIdentifiers(minuses);
        return minuses;
    }

    private List<String> buildOptions(DocketSummaryImpl docketSummary, SalesComponent currentComp) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> optionsIdentifiers = new ArrayList<String>();
        for (SalesOption option : currentComp.getCurrentOptions()) {
            if (!option.isPrintable()) continue;
            String optionLabel = option.getLabel();
            optionsIdentifiers.add(optionLabel);
            options.add(optionLabel);
        }
        docketSummary.addIdentifiers(optionsIdentifiers);
        return options;
    }

    private String buildWholeDesciption(DocketSummaryImpl docketSummary, SalesComponent currentComp) {
        StringBuilder newLine = new StringBuilder();
        if (!this.isPrintable()) {
            newLine.append(SPACE);
            newLine.append(currentComp.getUnit().getSize().getShortName());
            newLine.append(SPACE);
            newLine.append(currentComp.getShortNameSafely());
        }
        String value = newLine.toString();
        docketSummary.addIdentifier(value);
        this.appendExtraInfo(docketSummary, docketSummary.getOriginalSummary());
        return value;
    }

    private void buildPortionedDesciption(DocketSummaryImpl parentSummary, SalesComponent currentComp, boolean isFirstLine) {
        DocketSummaryImpl portionedSummary = new DocketSummaryImpl();
        StringBuilder newLine = new StringBuilder();
        newLine.append(currentComp.getUnit().getPortion().getFraction());
        newLine.append(SPACE);
        newLine.append(currentComp.getShortNameSafely());
        String description = newLine.toString();
        portionedSummary.setDescription(description);
        portionedSummary.setOptions(this.buildOptions(portionedSummary, currentComp));
        portionedSummary.setMinuses(this.buildMinuses(portionedSummary, currentComp));
        portionedSummary.setPluses(this.buildPluses(portionedSummary, currentComp));
        if (isFirstLine && this.isPrintable()) {
            this.appendExtraInfo(portionedSummary, parentSummary.getOriginalSummary());
        }
        parentSummary.addChildSummary(portionedSummary);
        parentSummary.addIdentifier(description);
        parentSummary.addIdentifiers(portionedSummary.getIdentifiers());
    }

    private void buildDocketSummaryGroup(DocketSummaryImpl docketSummaryGroup, SalesComponent currentComp, boolean isFirstLine) {
        if (isFirstLine) {
            if (!this.isPrintable()) {
                StringBuilder newLine = new StringBuilder();
                newLine.append(SPACE).append(currentComp.getUnit().getSize().getShortName()).append(SPACE).append(currentComp.getUnit().getPortion().getLabel()).append(SPACE).append(currentComp.getInventoryItem().getMenuGroup().getLabel());
                this.appendExtraInfo(docketSummaryGroup, docketSummaryGroup.getOriginalSummary());
                docketSummaryGroup.setDescription(newLine.toString());
                docketSummaryGroup.addIdentifier(newLine.toString());
            }
            this.qtyPrinted = true;
        }
        this.buildPortionedDesciption(docketSummaryGroup, currentComp, isFirstLine);
    }

    private void appendExtraInfo(DocketSummaryImpl docketSummary, SalesItemSummary itemSum) {
        StringBuilder line = new StringBuilder();
        if (!this.isPrintable() && itemSum.getSalesItem().getHoldTime() > 0) {
            line.append(SPACE);
            line.append("%");
        }
        if (this.isPricePrintable(itemSum.getSalesItem(), this.isDeliverable)) {
            line.append(SPACE);
            line.append(itemSum.getSalesItem().getItemLevelPrice());
        }
        String extraInfo = line.toString();
        docketSummary.addIdentifier(extraInfo);
        docketSummary.setExtraInfo(extraInfo);
    }

    private boolean isPricePrintable(SalesItem item, boolean deliverable) {
        if ("1".equals(ReportProperty.find(ReportGroup.General, "Visible of Combo Item Price on Prep Docket").getValue())) {
            return item.getOpenPrice() != null || item.isPriceEdited() || deliverable;
        }
        return !item.isComboItem() && (item.getOpenPrice() != null || item.isPriceEdited() || deliverable);
    }

    private String getFormattedQty(String qty, int spaces) {
        this.qtyPrinted = this.shouldPrintQty();
        StringBuilder newLine = new StringBuilder();
        int i = 0;
        if (!this.qtyPrinted) {
            if (spaces > 2) {
                newLine.append(SPACE);
                newLine.append(SPACE);
                i += 2;
            }
            newLine.append(qty);
            i += qty.length();
            this.qtyPrinted = true;
        }
        while (i < spaces) {
            newLine.append(SPACE);
            ++i;
        }
        return newLine.toString();
    }

    private String getState() {
        return this.sisg.getState();
    }

    private boolean isPrintable() {
        return this.sisg.isPrintable();
    }

    private List<SalesComponent> getSalesComponents(SalesItemSummary currentItemSum) {
        return currentItemSum.getSalesItem().getComponentList();
    }

    private boolean wholeMeal(SalesComponent currentComp) {
        return currentComp.getUnit().getPortion().getSize() == 1.0;
    }

    public int getSummariesSize() {
        return this.salesItemSummaries.size();
    }
}

