/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.units.SalesQuantity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.DocketSummary;

public class DocketSummaryImpl
implements DocketSummary,
Serializable {
    private SalesItemSummary originalSummary;
    private String description = "";
    private List<String> options;
    private List<String> minuses;
    private List<String> pluses;
    private String notes = "";
    private String seat = "";
    private String extraInfo = "";
    private List<String> identifiers;
    private SalesQuantity quantity = SalesQuantity.ZERO;
    private List<DocketSummary> childSummaries;
    private Map<Integer, Integer> seatMap;

    public DocketSummaryImpl() {
        this.identifiers = new ArrayList<String>();
        this.childSummaries = new ArrayList<DocketSummary>();
        this.seatMap = new HashMap<Integer, Integer>();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getOptions() {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        return this.options;
    }

    @Override
    public List<String> getMinuses() {
        if (this.minuses == null) {
            this.minuses = new ArrayList<String>();
        }
        return this.minuses;
    }

    @Override
    public List<String> getPluses() {
        if (this.pluses == null) {
            this.pluses = new ArrayList<String>();
        }
        return this.pluses;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String getSeat() {
        return this.seat;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public void setMinuses(List<String> someMinuses) {
        this.minuses = someMinuses;
    }

    @Override
    public void setNotes(String notesContent) {
        this.notes = notesContent;
    }

    public void setOptions(List<String> someOptions) {
        this.options = someOptions;
    }

    public void setPluses(List<String> somePluses) {
        this.pluses = somePluses;
    }

    public void setSeat(String aSeat) {
        this.seat = aSeat;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(25);
        if (!this.description.isEmpty()) {
            sb.append(this.description);
            sb.append("\n");
        }
        if (!this.options.isEmpty()) {
            sb.append(this.options);
            sb.append("\n");
        }
        if (!this.pluses.isEmpty()) {
            sb.append(this.pluses);
            sb.append("\n");
        }
        if (!this.minuses.isEmpty()) {
            sb.append(this.minuses);
            sb.append("\n");
        }
        sb.append(this.seat);
        return sb.toString();
    }

    public void setExtraInfo(String info) {
        this.extraInfo = info;
    }

    @Override
    public String getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public SalesItemSummary getOriginalSummary() {
        return this.originalSummary;
    }

    public void setOriginalSummary(SalesItemSummary summary) {
        this.originalSummary = summary;
    }

    public void addIdentifiers(List<String> ids) {
        this.identifiers.addAll(ids);
    }

    public void addIdentifier(String id) {
        this.identifiers.add(id);
    }

    public void addChildSummary(DocketSummary child) {
        this.childSummaries.add(child);
    }

    public void addChildSummaries(List<DocketSummary> children) {
        this.childSummaries.addAll(children);
    }

    public void setSeatMapping(Map<Integer, Integer> mapping) {
        this.seatMap.putAll(mapping);
    }

    public void setQuantity(SalesQuantity qty) {
        this.quantity = qty;
    }

    @Override
    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public SalesQuantity getQuantity() {
        return this.quantity;
    }

    @Override
    public List<DocketSummary> getChildSummaries() {
        return this.childSummaries;
    }

    @Override
    public Map<Integer, Integer> getSeatMapping() {
        return this.seatMap;
    }

    @Override
    public boolean hasChildSummary() {
        return this.childSummaries.size() > 0;
    }
}

