/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.util.MathsUtils;
import java.util.Collections;
import java.util.List;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.GroupByNameStrategy;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.database.sales.printSummary.sorting.SortByComboThenInventoryGroupItemNameStrategy;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;
import org.apache.commons.collections.keyvalue.MultiKey;

public class GroupByComboThenNameStrategy
extends GroupByNameStrategy {
    private static final int UNIQUE_IDENTIFIER = 0;
    private static final int COMBO_IDENTIFIER = 1;

    public GroupByComboThenNameStrategy() {
        super("Combo Then Item Name");
        super.setItemNameSort(false);
    }

    @Override
    public SummarySortingStrategy getDefaultSortingStrategy() {
        return new SortByComboThenInventoryGroupItemNameStrategy();
    }

    @Override
    public MultiKey figureOutUniqueIdentifier(SalesItem item) {
        MultiKey multiKey = super.figureOutUniqueIdentifier(item);
        long id = (Long)multiKey.getKey(0);
        String comboId = (String)multiKey.getKey(1);
        if (item.isComboItem()) {
            SalesCombo combo = item.getParentCombo();
            id = combo.isPersistent() ? MathsUtils.cantorPair((int)id, (int)combo.getCombo().getID().longValue()) : MathsUtils.cantorPair((int)id, combo.hashCode());
            comboId = combo.getHelper().getComboIdentifier();
        }
        return new MultiKey((Object)id, (Object)comboId);
    }

    @Override
    protected SalesItemSummaryGroup createNewSummaryGroup(List<SalesItemSummary> summaries, String systemState, Boolean reprinted, boolean itemNameSort) {
        SalesItemSummaryGroup group = super.createNewSummaryGroup(summaries, systemState, reprinted, itemNameSort);
        SalesItem item = group.getSummary().getSalesItem();
        if (item.isComboItem()) {
            List<SalesCombo> ids = Collections.singletonList(item.getParentCombo());
            group.setIdentifiers(ids);
            group.setHeaders(ids);
            group.setComboQuantityIndex(0);
        } else {
            group.setComboQuantityIndex(-1);
        }
        return group;
    }
}

