/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.util.MathsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.AbstractSummaryGroupingStrategy;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.database.sales.printSummary.sorting.SortByInventoryGroupItemNameStrategy;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;
import org.apache.commons.collections.keyvalue.MultiKey;

public class GroupByNameStrategy
extends AbstractSummaryGroupingStrategy {
    private boolean itemNameSort = true;

    public GroupByNameStrategy() {
        super("ItemName");
    }

    protected GroupByNameStrategy(String identifier) {
        super(identifier);
    }

    @Override
    public List<SalesItemSummaryGroup> group(List<SalesItemSummary> salesItemSummaries, String systemState, Boolean reprint) {
        this.initGroupMap(salesItemSummaries.size());
        for (SalesItemSummary summary : salesItemSummaries) {
            this.putIntoMap(this.figureOutUniqueIdentifier(summary.getSalesItem()), summary);
        }
        Set entrySet = this.getSummarySet();
        ArrayList<SalesItemSummaryGroup> summaryGroups = new ArrayList<SalesItemSummaryGroup>(entrySet.size());
        for (Map.Entry entry : entrySet) {
            List currentList = (List)entry.getValue();
            summaryGroups.add(this.createNewSummaryGroup(currentList, systemState, reprint, this.itemNameSort));
        }
        return summaryGroups;
    }

    @Override
    public SummarySortingStrategy getDefaultSortingStrategy() {
        return new SortByInventoryGroupItemNameStrategy();
    }

    protected MultiKey figureOutUniqueIdentifier(SalesItem item) {
        long id = 0L;
        for (SalesComponent comp : item.getComponentList()) {
            id = MathsUtils.cantorPair((int)id, (int)comp.getUnit().getID().longValue());
        }
        return new MultiKey((Object)id, (Object)"");
    }

    public void setItemNameSort(boolean value) {
        this.itemNameSort = value;
    }
}

