/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.persistence.PersistenceManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.misc.Course;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.itemfilter.CourseFilter;
import ordermate.database.sales.itemfilter.CourseHoldFilter;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.sales.itemfilter.ItemStateFilter;
import ordermate.database.sales.itemfilter.OrderableItemFilter;
import ordermate.database.sales.itemfilter.PrintedFilter;
import ordermate.database.sales.itemfilter.PrintedItemStateFilter;
import ordermate.database.sales.itemfilter.RefundedFilter;
import ordermate.database.workflow.QuantitiesToPrint;
import ordermate.docketprocessor.DocketProcessor;
import org.apache.commons.lang.SerializationUtils;

public class PrepDocketHelper {
    private Account account;
    private List<SalesItemQuantity> qtys;

    public static PrepDocketHelper create(Account account) {
        return new PrepDocketHelper(account, null);
    }

    public static PrepDocketHelper create(Account account, List<SalesItemQuantity> qtys) {
        return new PrepDocketHelper(account, qtys);
    }

    private PrepDocketHelper(Account theAccount, List<SalesItemQuantity> theQtys) {
        this.account = theAccount;
        this.qtys = theQtys;
    }

    public int getLastPrintableCourse(VirtualPrinter printer, Terminal terminal) {
        int largestCourse = 0;
        for (int course = 0; course < Account.getCourses().length; ++course) {
            boolean printCurrent = false;
            List<VirtualPrinter> notifyPrinters = VirtualPrinter.getNotifyPrinters(this.getAllSalesItems(), course, printer, terminal);
            boolean bl = printCurrent = !notifyPrinters.isEmpty();
            if (!printCurrent) {
                List courseItems = this.getAllItems(false, course);
                Iterator it = courseItems.iterator();
                while (it.hasNext() && !printCurrent) {
                    SalesLineItem item = (SalesLineItem)it.next();
                    printCurrent = item.isPrintableThrough(terminal, printer);
                }
            }
            if (!printCurrent) continue;
            largestCourse = course;
        }
        return largestCourse;
    }

    public List<SalesItem> getAllItems(Boolean printed) {
        List<SalesItem> items = ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new PrintedFilter(printed), new RefundedFilter(), new OrderableItemFilter());
        return items;
    }

    protected boolean needsPrinting(Terminal printedFrom) {
        List<SalesItem> itemsToPrint = this.getAllItems(Boolean.FALSE);
        if (itemsToPrint.isEmpty()) {
            return false;
        }
        Collection<VirtualPrinter> virtualPrinters = VirtualPrinter.getDocketPrintersForItems(itemsToPrint, printedFrom);
        virtualPrinters.addAll(this.getSummaryPrinters());
        return !virtualPrinters.isEmpty();
    }

    public List<VirtualPrinter> getSummaryPrinters() {
        List<VirtualPrinter> printers = PersistenceManager.getObjectList(VirtualPrinter.class, "SELECT config_printer_virtual.* FROM config_printer_virtual, config_printer_summary WHERE config_printer_summary.FK_config_printer_virtual = config_printer_virtual.ID AND config_printer_summary.account_type = ?", new Object[]{this.account.getAccountType().toString()});
        return printers;
    }

    public void markItemsAsPrinted() {
        for (SalesLineItem item : this.account.getAllItems()) {
            if (this.isItemCourseOnHold(item)) continue;
            item.markPrinted();
        }
    }

    private boolean isItemCourseOnHold(SalesLineItem salesLineItem) {
        Account account = salesLineItem.getAccount();
        if (!(account instanceof TableAccount)) {
            return false;
        }
        TableAccount tableAccount = (TableAccount)account;
        return tableAccount.isCoursePrintOnHold(this.getCourse(salesLineItem.getCourse()));
    }

    private Course getCourse(int index) {
        Course result = null;
        List<Course> courseList = Course.getCourses();
        for (Course course : courseList) {
            if (course.getCourseIndex() != index) continue;
            result = course;
            break;
        }
        return result;
    }

    public void markCourseItemsAsPrinted(int index) {
        for (SalesLineItem item : this.account.getAllItems()) {
            if (item.getCourse() > index) continue;
            item.markPrinted();
        }
    }

    public void printTransferPrepDockets(Account targetAccount, Terminal printedFrom) throws Exception {
        if (this.needsPrinting(printedFrom)) {
            DocketProcessor.printTransferDocket(this.account, targetAccount, this.account.getUser(), printedFrom);
        }
    }

    public void printPrepDockets(Terminal printedFrom, boolean clone, boolean rushed) throws Exception {
        if (this.needsPrinting(printedFrom)) {
            Account toPrint = clone ? (Account)SerializationUtils.clone((Serializable)this.account) : this.account;
            DocketProcessor.printPrepDocket(toPrint, this.account.getUser(), printedFrom, rushed);
            this.markItemsAsPrinted();
        }
    }

    public List<SalesItem> getAllItems(Boolean printed, String itemState, int course) {
        List<SalesItem> allSalesItems = ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new PrintedItemStateFilter(printed, itemState), new CourseFilter(course), new OrderableItemFilter());
        return allSalesItems;
    }

    private List<SalesItem> getSalesItemFromQuantity(List<SalesItemQuantity> quantities) {
        ArrayList<SalesItem> allSalesItems = new ArrayList<SalesItem>();
        if (quantities != null) {
            for (SalesItemQuantity qty : quantities) {
                for (SalesItem item : qty.getSalesLineItem().getSalesItems()) {
                    if (allSalesItems.contains(item)) continue;
                    allSalesItems.add(item);
                }
            }
        }
        return allSalesItems;
    }

    private List<SalesItem> getAllSalesItems() {
        ArrayList<SalesItem> allSalesItems = null;
        if (this.qtys != null) {
            allSalesItems = new ArrayList<SalesItem>();
            allSalesItems.addAll(this.getSalesItemFromQuantity(this.qtys));
        } else if (this.account != null) {
            allSalesItems = new ArrayList(this.account.getAllItems().size());
            for (SalesLineItem currentItem : this.account.getAllItems()) {
                allSalesItems.addAll(currentItem.getSalesItems());
            }
        } else {
            allSalesItems = new ArrayList();
        }
        return allSalesItems;
    }

    public List<SalesItem> getAllItems(Boolean printed, String itemState) {
        return ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new PrintedItemStateFilter(printed, itemState), new OrderableItemFilter());
    }

    public List getAllItems(boolean printed, int course) {
        return ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new PrintedFilter(printed), new CourseFilter(course), new OrderableItemFilter());
    }

    public List<SalesItem> getAllItems(String itemState) {
        return ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new ItemStateFilter(itemState), new OrderableItemFilter());
    }

    public List<SalesItem> getCourseStateItems(int course, String itemState) {
        if (itemState == null) {
            return ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new CourseFilter(course));
        }
        return ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new ItemStateFilter(itemState), new CourseFilter(course), new OrderableItemFilter());
    }

    public List<SalesItem> getUnprintedItemsOnOrBeforeCourse(int course) {
        return ItemFilter.filterItems(this.getAllSalesItems(), new CourseHoldFilter(), new PrintedFilter(Boolean.FALSE), new CourseFilter(course, true), new OrderableItemFilter());
    }

    public String getQuantityFromComponentDescription(String description) {
        if (description.isEmpty() || description == null || description.trim().isEmpty()) {
            return "";
        }
        String leadingSpaces = "";
        if (!description.contains(" ") || !description.trim().contains(" ")) {
            OrderMate.LOG.warn("Got a weird description: \"" + description + "\". Call a dev and take a look.");
            return description;
        }
        for (int i = 0; i < description.length() && ' ' == description.charAt(i); ++i) {
            leadingSpaces = leadingSpaces + " ";
        }
        return leadingSpaces + description.trim().substring(0, description.trim().indexOf(" "));
    }

    public String getDescriptionTextFromComponentDescription(String description) {
        if (description.isEmpty() || description == null || description.trim().isEmpty() || !description.contains(" ") || !description.trim().contains(" ")) {
            OrderMate.LOG.warn("Got a weird description: " + description + ". Call a dev and take a look.");
            return "";
        }
        return description.trim().substring(description.trim().indexOf(" "));
    }

    public Collection<? extends SalesItem> getItemsOnCourse(Course course, boolean printed) {
        return ItemFilter.filterItems(this.getAllSalesItems(), new CourseFilter(course.getCourseIndex(), false), new PrintedFilter(printed), new OrderableItemFilter());
    }

    public List<SalesItem> getItemsForVirtualPrinter(Set<QuantitiesToPrint> quantitiesToPrint, String itemState, int course) {
        ArrayList<SalesItemQuantity> salesItemQuantities = new ArrayList<SalesItemQuantity>();
        if (quantitiesToPrint != null) {
            for (QuantitiesToPrint qtyToPrint : quantitiesToPrint) {
                salesItemQuantities.addAll(qtyToPrint.getQuantitiesToPrint());
            }
        }
        List<SalesItem> salesItems = this.getSalesItemFromQuantity(salesItemQuantities);
        return ItemFilter.filterItems(salesItems, new CourseFilter(course, false), new PrintedItemStateFilter(false, itemState), new OrderableItemFilter());
    }
}

