/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.propertyaccessor.ListChainPropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessorVendor;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Pair;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.hardware.GroupingHeaderType;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.AbstractSummaryGroupingStrategy;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.database.sales.printSummary.sorting.PropertySortingStrategy;
import ordermate.database.sales.printSummary.sorting.SortingStrategyVendor;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;

public class PropertySummaryGroupingStrategy
extends AbstractSummaryGroupingStrategy {
    private List<Pair<PropertyAccessor, GroupingHeaderType>> identifiers = new ArrayList<Pair<PropertyAccessor, GroupingHeaderType>>();
    private SummarySortingStrategy sortingStrategy;

    protected PropertySummaryGroupingStrategy(String theIdentifier) {
        super(theIdentifier);
    }

    public void addGroupingHeader(PropertyAccessor accessor, GroupingHeaderType headerType) {
        if (accessor != null) {
            this.identifiers.add(new Pair<PropertyAccessor, GroupingHeaderType>(accessor, headerType == null ? GroupingHeaderType.None : headerType));
        }
    }

    @Override
    public List<SalesItemSummaryGroup> group(List<SalesItemSummary> salesItemSummaries, String systemState, Boolean reprint) {
        this.initGroupMap(salesItemSummaries.size());
        for (SalesItemSummary summary : salesItemSummaries) {
            this.putIntoMap(this.figureOutUniqueIdentifier(summary.getSalesItem()), summary);
        }
        Set entrySet = this.getSummarySet();
        ArrayList<SalesItemSummaryGroup> summaryGroups = new ArrayList<SalesItemSummaryGroup>(entrySet.size());
        boolean isSortByName = true;
        for (Map.Entry entry : entrySet) {
            List currentList = (List)entry.getValue();
            summaryGroups.add(this.createNewSummaryGroup(currentList, systemState, reprint, isSortByName));
        }
        return summaryGroups;
    }

    @Override
    protected SalesItemSummaryGroup createNewSummaryGroup(List<SalesItemSummary> summaries, String systemState, Boolean reprinted, boolean itemNameSort) {
        SalesItemSummaryGroup group = super.createNewSummaryGroup(summaries, systemState, reprinted, itemNameSort);
        if (!this.identifiers.isEmpty()) {
            ArrayList ids = new ArrayList();
            ArrayList<Object> headers = new ArrayList<Object>();
            boolean empty = true;
            int comboQtyIndex = -1;
            int i = 0;
            for (Pair<PropertyAccessor, GroupingHeaderType> idAccessor : this.identifiers) {
                Object value = ((PropertyAccessor)idAccessor.key).resolveValue(group.getSummary().getSalesItem());
                if (GroupingHeaderType.HeaderId.equals(idAccessor.value) || GroupingHeaderType.Header.equals(idAccessor.value)) {
                    boolean bl = empty = empty && value == null;
                    if (value instanceof Collection && ((Collection)value).size() == 1) {
                        headers.add(((Collection)value).iterator().next());
                    } else {
                        headers.add(value);
                    }
                    if (InventoryCombo.class.equals(((PropertyAccessor)idAccessor.key).getProperty().getOwner())) {
                        comboQtyIndex = headers.size() - 1;
                    } else if (SalesCombo.class.equals(((PropertyAccessor)idAccessor.key).getProperty().getOwner())) {
                        comboQtyIndex = headers.size() - 1;
                    }
                }
                if (GroupingHeaderType.HeaderId.equals(idAccessor.value) || GroupingHeaderType.Id.equals(idAccessor.value)) {
                    ids.add(value);
                }
                ++i;
            }
            group.setIdentifiers(ids);
            group.setComboQuantityIndex(comboQtyIndex);
            if (!empty) {
                group.setHeaders(headers);
            }
        }
        return group;
    }

    public Object figureOutUniqueIdentifier(SalesItem item) {
        long id = 0L;
        for (Pair<PropertyAccessor, GroupingHeaderType> accessor : this.identifiers) {
            Object value = ((PropertyAccessor)accessor.key).resolveValue(item);
            if (value != null) {
                if (value instanceof Collection) {
                    for (Object next : (Collection)value) {
                        if (next == null) {
                            next = 0;
                        } else if (next instanceof PersistentObject) {
                            next = ((PersistentObject)next).isPersistent() ? ((PersistentObject)next).getID() : (long)next.hashCode();
                        } else if (!(next instanceof Number)) {
                            next = next.hashCode();
                        }
                        id = MathsUtils.cantorPair((int)id, ((Number)next).intValue());
                    }
                    continue;
                }
                if (value instanceof PersistentObject) {
                    value = ((PersistentObject)value).isPersistent() ? ((PersistentObject)value).getID() : (long)value.hashCode();
                } else if (!(value instanceof Number)) {
                    value = value.hashCode();
                }
                id = MathsUtils.cantorPair((int)id, ((Number)value).intValue());
                continue;
            }
            id = MathsUtils.cantorPair((int)id, 0);
        }
        return id;
    }

    @Override
    public SummarySortingStrategy getDefaultSortingStrategy() {
        if (this.sortingStrategy == null) {
            PropertySortingStrategy strategy = new PropertySortingStrategy();
            for (Pair<PropertyAccessor, GroupingHeaderType> next : this.identifiers) {
                if (((PropertyAccessor)next.key).getProperty().equals(InventoryItemUnit.Properties.ID)) {
                    strategy.addComparison(new ListChainPropertyAccessor(SalesItem.Properties.COMPONENTS, SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.LABEL));
                    continue;
                }
                strategy.addComparison((PropertyAccessor)next.key);
            }
            this.sortingStrategy = strategy;
        }
        return this.sortingStrategy;
    }

    public void setDefaultSortingStrategy(SummarySortingStrategy strategy) {
        this.sortingStrategy = strategy;
    }

    public static PropertySummaryGroupingStrategy createStrategyFrom(DocketGrouping grouping) {
        PropertyAccessorVendor vendor = DocketGrouping.getVendor();
        PropertySummaryGroupingStrategy strategy = new PropertySummaryGroupingStrategy(grouping.getLabel());
        for (int i = 0; i < 5; ++i) {
            try {
                Method method = grouping.getClass().getMethod("getGroup" + (i + 1), new Class[0]);
                PropertyAccessor accessor = vendor.fromString((String)method.invoke((Object)grouping, new Object[0]));
                if (accessor == null) continue;
                method = grouping.getClass().getMethod("getHeader" + (i + 1), new Class[0]);
                GroupingHeaderType type = (GroupingHeaderType)((Object)method.invoke((Object)grouping, new Object[0]));
                strategy.addGroupingHeader(accessor, type);
                continue;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error accessing group or header method:", (Throwable)ex);
            }
        }
        if (grouping.getDefaultSorting() != null) {
            SortingStrategyVendor.getSortingStrategy(grouping.getDefaultSorting(), grouping.getDefaultSorting().getID().toString());
        }
        return strategy;
    }
}

