/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.VoucherTransaction;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.resource.DocketImage;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComboSummary;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesItemSummaryCreator;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.sales.itemfilter.OrderableItemFilter;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollection;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollectionStrategy;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollectionStrategyFactory;
import ordermate.database.sales.printSummary.sorting.SortingStrategyVendor;
import ordermate.database.tables.LogicalTable;
import ordermate.internationalization.Internationalization;

public class ReceiptDocketHelper {
    private final DecimalFormat weightFormat = new DecimalFormat("#0.000");
    private final DecimalFormat unitFormat = new DecimalFormat("0.#");
    private final DecimalFormat priceFormat = new DecimalFormat(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00#####");
    public static final String DEFAULT_TITLE = "TAX INVOICE";
    private ItemGroup groupToPrint;
    private boolean printDeleted;
    private boolean printRefunded;
    private boolean printAdjusted;
    private boolean printAllItems;
    private Price totalDeleted;
    private Price totalDeletedExTax;
    private Price totalDeletedTax;
    private Price totalRefunded = new Price(Price.ZERO_DOLLAR);
    private Price totalRefundedTax;
    private Price newDeletedPrice;
    private SalesQuantity numNewDeleted;
    private SalesQuantity numRefunded = new SalesQuantity("0");
    private SalesQuantity numNormalItems;
    private int numAdjusted;
    private String[] docketTitle;
    private Iterator summaries;
    private SalesItemSummary currentSummary;
    private GiftVoucherTransaction topupVoucherTxn;
    private Iterator<SalesItemSummaryCollection> collections;
    private Iterator<GiftVoucherTransaction> voucherTopupTxns;
    private SalesItemSummaryCollection<?> currentCollection;
    private Map<Long, SalesComboSummary> combos = new HashMap<Long, SalesComboSummary>();
    public static final String AUTO_PRINT_REASON_ADJ = "Price Adjustment";
    public static final String AUTO_PRINT_REASON_DELETE = "Items Deleted";

    public ReceiptDocketHelper(ItemGroup toBePrinted, VirtualPrinter printer) {
        if (toBePrinted.getCustomer() != null && toBePrinted.getCustomer().hasChanged()) {
            toBePrinted.updateCustomerReference();
        }
        this.groupToPrint = toBePrinted;
        String receiptPrintReason = null;
        receiptPrintReason = this.groupToPrint.getReceiptPrintReason();
        if (receiptPrintReason != null) {
            this.printDeleted = receiptPrintReason.contains(AUTO_PRINT_REASON_DELETE);
            this.printAdjusted = receiptPrintReason.contains(AUTO_PRINT_REASON_ADJ);
        }
        this.makeDocketTitle(receiptPrintReason);
        this.printAllItems = !this.printDeleted && !this.printAdjusted || this.printAdjusted && this.groupToPrint.getPriceAdjustments().size() > 0;
        SalesItemSummaryCollectionStrategyFactory factory = new SalesItemSummaryCollectionStrategyFactory();
        SalesItemSummaryCollectionStrategy collectionStrategy = null;
        if (printer != null) {
            collectionStrategy = factory.createStrategy(printer.getDocketGroupingRec());
        }
        if (collectionStrategy == null) {
            collectionStrategy = factory.createStrategy(SystemProperty.getInstance().getReceiptGrouping());
        }
        SalesItemSummaryCreator creator = this.makeSummaryCreator(printer);
        ExperimentalFeature honourZeroPrice = ExperimentalFeature.find("honour_zero_price_options");
        if (honourZeroPrice == null || !honourZeroPrice.getBooleanValue(Boolean.FALSE).booleanValue()) {
            creator.ignoreZeroPricedOptions();
        }
        collectionStrategy.makeCollections(creator.getSummaries(this.getSellableItems(this.groupToPrint.getAllItems())));
        this.collections = collectionStrategy.getCollections().iterator();
        this.totalDeleted = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        this.totalDeletedExTax = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        this.totalDeletedTax = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        this.totalRefundedTax = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        this.buildSalesComboItems(collectionStrategy.getCollections());
    }

    private List<? extends SalesLineItem> getSellableItems(List<SalesLineItem> allItems) {
        return ItemFilter.filterItems(allItems, new OrderableItemFilter());
    }

    private SalesItemSummaryCreator makeSummaryCreator(VirtualPrinter printer) {
        if (printer == null) {
            return new SalesItemSummaryCreator();
        }
        boolean ignoreSeats = true;
        DocketGrouping grouping = printer.getDocketGroupingRec();
        if (grouping != null) {
            StringBuilder SB = new StringBuilder(grouping.getGroup1()).append(grouping.getGroup2()).append(grouping.getGroup3()).append(grouping.getGroup4()).append(grouping.getGroup5());
            ignoreSeats = !SB.toString().contains("#seat");
        }
        SalesItemSummaryCreator creator = new SalesItemSummaryCreator(SortingStrategyVendor.getSortingStrategy(printer.getDocketSortingRec(), printer.getDocketSortingStrategy()));
        if (!ignoreSeats) {
            creator.dontIgnoreSeat();
        }
        return creator;
    }

    private boolean buildSalesComboItems(List collections2) {
        List siscCollections = collections2;
        for (SalesItemSummaryCollection sisc : siscCollections) {
            for (SalesItemSummary salesItemSum : sisc.getSummaries()) {
                for (SalesItem salesItem : salesItemSum.getSalesItems()) {
                    for (SalesComponent salesComp : salesItem.getComponentList()) {
                        if (salesComp.getSalesItem().getParentCombo() == null) continue;
                        Long comboKey = salesComp.getSalesItem().getParentCombo().getCombo().getID();
                        if (!this.combos.containsKey(comboKey)) {
                            this.combos.put(comboKey, new SalesComboSummary());
                        }
                        this.combos.get(comboKey).absorbCombo(salesComp.getSalesItem().getParentCombo());
                    }
                }
            }
        }
        return true;
    }

    private void makeDocketTitle(String receiptPrintReason) {
        this.docketTitle = receiptPrintReason == null ? new String[]{DEFAULT_TITLE} : receiptPrintReason.split(",");
    }

    public boolean nextCollection() {
        if (this.collections.hasNext()) {
            this.currentCollection = this.collections.next();
            this.summaries = new ArrayList<SalesItemSummary>(this.currentCollection.getSummaries()).iterator();
        } else {
            this.currentCollection = null;
        }
        return this.currentCollection != null;
    }

    public String getCollectionLabel() {
        if (this.currentCollection != null) {
            return this.currentCollection.getDocketLabel();
        }
        return null;
    }

    public String getCollectionTotal() {
        if (this.currentCollection != null) {
            Price total = Price.ZERO_DOLLAR;
            for (SalesItemSummary summary : this.currentCollection.getSummaries()) {
                total = total.add(summary.getTotalPrice());
            }
            return total.toString(true);
        }
        return null;
    }

    public SalesItemSummary getNextSalesItemSummary() {
        if (this.summaries.hasNext()) {
            List<SalesPriceAdjustment> adj;
            this.currentSummary = (SalesItemSummary)this.summaries.next();
            this.numNewDeleted = SalesQuantity.ZERO;
            if (this.printDeleted) {
                this.numNewDeleted = this.numNewDeleted.add(this.currentSummary.getTotalCommittedQuantity(false, "DELETED"));
                this.numNewDeleted = this.numNewDeleted.add(this.currentSummary.getTotalCommittedQuantity(false, "DELETED_WASTED"));
                Price oneItemPrice = this.currentSummary.getSalesItem().getItemLevelPricePerItem();
                Price unitTax = this.currentSummary.getSalesItem().getUnitTax();
                Price currentTotalNewDeletedPrice = oneItemPrice.multiply(this.numNewDeleted);
                this.newDeletedPrice = SystemProperty.getInstance().isExTax() ? currentTotalNewDeletedPrice.add(unitTax.multiply(this.numNewDeleted)) : currentTotalNewDeletedPrice;
                this.totalDeleted = this.totalDeleted.add(this.newDeletedPrice);
                this.totalDeletedExTax = this.totalDeletedExTax.add(currentTotalNewDeletedPrice);
                this.totalDeletedTax = this.totalDeletedTax.add(unitTax.multiply(this.numNewDeleted));
                this.numNewDeleted = this.numNewDeleted.negate();
            }
            this.numNormalItems = SalesQuantity.ZERO;
            SalesQuantity numNewRefunded = SalesQuantity.ZERO;
            if (this.printAllItems) {
                numNewRefunded = numNewRefunded.add(this.currentSummary.getTotalQuantity("REFUNDED"));
                if ((numNewRefunded = numNewRefunded.add(this.currentSummary.getTotalQuantity("REFUNDED_WASTED"))).lessThan(0L)) {
                    numNewRefunded = numNewRefunded.negate();
                }
                Price refundedPerItemPrice = this.currentSummary.getSalesItem().getItemLevelPricePerItem();
                Price unitTax = this.currentSummary.getSalesItem().getUnitTax();
                Price newRefundedPrice = refundedPerItemPrice.multiply(numNewRefunded);
                newRefundedPrice = SystemProperty.getInstance().isExTax() ? newRefundedPrice.add(unitTax.multiply(numNewRefunded)) : newRefundedPrice;
                this.totalRefunded = this.totalRefunded.add(newRefundedPrice);
                this.totalRefundedTax = this.totalRefundedTax.add(unitTax.multiply(numNewRefunded));
                this.numRefunded = this.numRefunded.add(numNewRefunded);
                this.numNormalItems = this.currentSummary.getTotalQuantity();
            }
            this.numAdjusted = 0;
            if (this.printAdjusted && (adj = this.currentSummary.getAdjustments()) != null) {
                this.numAdjusted = adj.size();
            }
        } else {
            this.currentSummary = null;
        }
        return this.currentSummary;
    }

    public String[] getDocketTitle() {
        return this.docketTitle;
    }

    public boolean isPrintNormalItems() {
        return this.printAllItems;
    }

    public boolean isPrintNewDeleted() {
        return this.printDeleted;
    }

    public boolean isPrintAdjusted() {
        return this.printAdjusted;
    }

    public boolean isDebtorSale() {
        return this.groupToPrint.isAccount() && ((Account)this.groupToPrint).getUniqueDebtorSale() != null;
    }

    public List<DebtorPayment> getDebtorPayments() {
        List<DebtorPayment> payments = DebtorSale.getDebtorPayments(Collections.singletonList(((Account)this.groupToPrint).getUniqueDebtorSale()));
        return payments;
    }

    public SalesQuantity getNumNewDeleted() {
        return this.numNewDeleted;
    }

    public SalesQuantity getNumRefunded() {
        return this.numRefunded;
    }

    public Price getCostOfNewDeleted() {
        return this.newDeletedPrice;
    }

    public Price getTotalCostOfNewDeleted() {
        return this.totalDeleted;
    }

    public Price getTotalCostOfNewDeletedExTax() {
        return this.totalDeletedExTax;
    }

    public Price getTotalDeletedTax() {
        return this.totalDeletedTax;
    }

    public int getNumAdjusted() {
        return this.numAdjusted;
    }

    public SalesQuantity getNumNormal() {
        return this.numNormalItems;
    }

    public String getQuantityString(SalesQuantity qty, String weightSuffix) {
        InventoryItem item = this.currentSummary.getSalesItem().getInventoryItemIfSingle();
        if (item != null && !InventoryWeightUnit.NA.equals((Object)item.getInventoryWeightUnit())) {
            return this.createCompliantWeightString(item.getInventoryWeightUnit(), qty, weightSuffix);
        }
        return qty.toString();
    }

    private String createCompliantWeightString(InventoryWeightUnit unit, SalesQuantity qty, String weightSuffix) {
        StringBuilder SB = unit.getFactor() == 1 ? new StringBuilder(this.weightFormat.format(qty.getValue())) : new StringBuilder(this.unitFormat.format(qty.getValue().doubleValue() * (double)unit.getFactor()));
        SB.append(unit.getDisplay());
        if (weightSuffix != null) {
            SB.append(weightSuffix);
        }
        return SB.toString();
    }

    public String makePerUnitPrice(SalesComponent comp) {
        Price price = comp.getSavedUnitPrice();
        if (comp.getSalesItem().getComponentList() != null && comp.getSalesItem().getComponentList().size() == 1 && "1".equals(ReportProperty.find(ReportGroup.General, "Items in Receipt Docket show default price").getValue())) {
            price = comp.getSalesItem().getUnadjustedPrice();
        }
        Price compPrice = comp.getPrice();
        if (SystemProperty.getInstance().isExTax()) {
            price = price.subtract(comp.getTax());
            compPrice = compPrice.subtract(comp.getTax());
        }
        InventoryWeightUnit weightUnit = comp.getInventoryItem().getInventoryWeightUnit();
        StringBuilder SB = new StringBuilder();
        if (weightUnit != null && !InventoryWeightUnit.NA.equals((Object)weightUnit)) {
            SB.append(comp.getBasePriceWithoutSurcharges().toString(true));
            SB.append("/").append(weightUnit.getDisplay());
        } else {
            SB.append(price.toString(true)).append("ea");
        }
        return SB.toString();
    }

    protected Map<Long, SalesComboSummary> getCombos() {
        return this.combos;
    }

    public SalesComboSummary getCombo(Long comboKey) {
        return this.combos.get(comboKey);
    }

    public String getExtraLabelFor(ItemGroup account) {
        LogicalTable table;
        if (account instanceof BarTabAccount && (table = ((BarTabAccount)account).getLogicalTable()) != null) {
            return "Table " + table.getGroupAndLabel();
        }
        return null;
    }

    public boolean accountHasTip(ItemGroup account) {
        List<FinanceTransaction> transactions = account.getFinanceTransactions();
        for (FinanceTransaction transaction : transactions) {
            if (transaction.getTip() == null || transaction.getTip().equals(Price.ZERO_DOLLAR)) continue;
            return true;
        }
        return false;
    }

    public String getTotalTip(ItemGroup account) {
        List<FinanceTransaction> transactions = account.getFinanceTransactions();
        Price totalTip = new Price(0.0, 0.01);
        for (FinanceTransaction transaction : transactions) {
            if (transaction.getTip() == null || transaction.getTip().equals(Price.ZERO_DOLLAR)) continue;
            totalTip = totalTip.add(transaction.getTip());
        }
        return totalTip.toString(true);
    }

    public boolean containsWeightedItems() {
        List lineItems = this.groupToPrint.getAllItems();
        for (SalesLineItem lineItem : lineItems) {
            List<SalesItem> salesItems = lineItem.getSalesItems();
            for (SalesItem salesItem : salesItems) {
                InventoryItem item = salesItem.getInventoryItemIfSingle();
                if (item == null || InventoryWeightUnit.NA.equals((Object)item.getInventoryWeightUnit())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isWeighted(SalesComponent comp) {
        boolean toReturn = false;
        InventoryItem item = comp.getInventoryItem();
        if (item != null) {
            toReturn = InventoryWeightUnit.NA != item.getInventoryWeightUnit();
        }
        return toReturn;
    }

    public boolean hasManuallyEnteredWeight(SalesComponent comp) {
        return comp.getSalesItem().isWeightManuallyEntered();
    }

    public DocketImage triggerImage(String group, TriggerActivationContext context) {
        List<DocketImage> docketImages = PersistenceManager.getObjectList(DocketImage.class, Query.select(DocketImage.class).equals(DocketImage.Properties.IMAGE_GROUP, group).orderBy(DocketImage.Properties.SEQUENCE).toString());
        for (DocketImage nextImage : docketImages) {
            if (!nextImage.isActive(context)) continue;
            return nextImage;
        }
        return null;
    }

    public List<GiftVoucherTransaction> getVoucherTopupsInGroup(boolean reversal) {
        ArrayList<GiftVoucherTransaction> voucherTopups = new ArrayList<GiftVoucherTransaction>();
        if (this.hasAnyVoucherActivity()) {
            Account account = this.groupToPrint.getAccount();
            for (GiftVoucherTransaction vTxn : account.getActiveVoucherTxns()) {
                if (!reversal) {
                    if (!vTxn.isTopup()) continue;
                    voucherTopups.add(vTxn);
                    continue;
                }
                if (!vTxn.isTopupReversal()) continue;
                voucherTopups.add(vTxn);
            }
        }
        this.voucherTopupTxns = voucherTopups.iterator();
        return voucherTopups;
    }

    public boolean hasAnyVoucherActivity() {
        if (this.groupToPrint instanceof Account) {
            Account account = this.groupToPrint.getAccount();
            return account.getVoucherTxns() != null && account.getVoucherTxns().size() > 0;
        }
        return false;
    }

    public GiftVoucherTransaction getNextVoucherTxn() {
        this.topupVoucherTxn = this.voucherTopupTxns != null && this.voucherTopupTxns.hasNext() ? this.voucherTopupTxns.next() : null;
        return this.topupVoucherTxn;
    }

    public GiftVoucher getVoucher(FinanceTransaction transaction) {
        VoucherTransaction voucherTxn;
        GiftVoucher voucher = null;
        if (transaction != null && transaction instanceof VoucherTransaction && (voucherTxn = (VoucherTransaction)transaction).getAuthCode() != null && !voucherTxn.getAuthCode().isEmpty() && voucherTxn.getGiftVoucherTxn() != null && voucherTxn.getGiftVoucherTxn().getAmount().lessThan(Price.ZERO_NO_ROUND)) {
            voucher = (GiftVoucher)PersistenceManager.reacquire(voucherTxn.getGiftVoucherTxn().getGiftVoucher());
        }
        return voucher;
    }

    public List<Pair<TaxCode, Price>> getAllTaxes() {
        Account account = this.groupToPrint.getAccount();
        ArrayList<Pair<TaxCode, Price>> multipleTaxes = new ArrayList<Pair<TaxCode, Price>>();
        if (account != null) {
            HashMap<TaxCode, Price> map = new HashMap<TaxCode, Price>();
            for (SalesLineItem lineItem : account.getItems()) {
                for (SalesItem item : lineItem.getSalesItems()) {
                    for (SalesComponent comp : item.getComponentList()) {
                        for (SalesComponentTax tax : comp.getTaxes()) {
                            if (!map.containsKey(tax.getTaxCode())) {
                                map.put(tax.getTaxCode(), tax.getValue());
                                map.put(tax.getTaxCode(), tax.getValue().multiply(item.getQuantity()));
                                continue;
                            }
                            Price taxPrice = (Price)map.get(tax.getTaxCode());
                            map.put(tax.getTaxCode(), taxPrice.add(tax.getValue().multiply(item.getQuantity())));
                        }
                    }
                }
            }
            for (TaxCode code : map.keySet()) {
                Price taxValue = (Price)map.get(code);
                if (Price.ZERO_DOLLAR.equals(taxValue)) continue;
                multipleTaxes.add(new Pair<TaxCode, Price>(code, taxValue));
            }
            if (multipleTaxes.size() > 1) {
                Comparator<Pair<TaxCode, Price>> priceComparator = new Comparator<Pair<TaxCode, Price>>(){

                    @Override
                    public int compare(Pair p1, Pair p2) {
                        return ((TaxCode)p1.key).getLabel().compareTo(((TaxCode)p2.key).getLabel());
                    }
                };
                Collections.sort(multipleTaxes, priceComparator);
            }
        }
        return multipleTaxes;
    }
}

