/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.DocketSummary;
import ordermate.database.sales.printSummary.DocketSummaryBuilder;

public class SalesItemSummaryGroup
implements Serializable,
PropertiedObject {
    public static final Props Properties = new Props();
    private SalesQuantity quantity;
    private SalesQuantity comboQuantity;
    private String description = "";
    private final List<SalesItemSummary> summaries = new ArrayList<SalesItemSummary>();
    private String state;
    private Integer holdTime;
    private List<? extends Object> identifiers;
    private List<? extends Object> headers;
    private int comboQuantityIndex = -1;

    @Deprecated
    public SalesItemSummaryGroup() {
    }

    public SalesItemSummaryGroup(List<SalesItemSummary> summaries, SalesQuantity newQuantity, String newDescription, String newState) {
        this.setSummaries(summaries);
        this.quantity = newQuantity;
        this.description = newDescription;
        this.state = newState;
    }

    public InventoryWeightUnit getWeightUnit() {
        if (this.summaries.size() > 0) {
            return this.summaries.get(0).getInventoryWeightUnit();
        }
        return InventoryWeightUnit.NA;
    }

    public void setQuantity(SalesQuantity newQuantity) {
        this.quantity = newQuantity;
    }

    public SalesQuantity getQuantity() {
        return this.quantity;
    }

    public String getQuantityString() {
        return InventoryWeightUnit.convertToString(this.getWeightUnit(), this.quantity);
    }

    public void addQuantity(SalesQuantity newQuantity) {
        this.quantity = this.quantity.add(newQuantity);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription == null ? "" : newDescription;
    }

    public void setSummaries(List<SalesItemSummary> newSummaries) {
        this.summaries.clear();
        this.summaries.addAll(newSummaries);
    }

    public List<SalesItemSummary> getSummaries() {
        return Collections.unmodifiableList(this.summaries);
    }

    public SalesItemSummary getSummary() {
        return this.summaries.get(0);
    }

    public void setState(String newState) {
        this.state = newState;
    }

    public String getState() {
        return this.state;
    }

    public boolean isPrintable() {
        return this.quantity.notEquals(0) && !this.description.isEmpty();
    }

    public int getSummariesSize() {
        return this.summaries.size();
    }

    public List<DocketSummary> getDocketSummaries(boolean isDeliverable, boolean isReprint) {
        DocketSummaryBuilder docketSumBuilder = new DocketSummaryBuilder(this, isDeliverable, isReprint);
        return docketSumBuilder.buildDocketSummaries();
    }

    public int getHoldTime() {
        if (this.holdTime == null && !this.summaries.isEmpty()) {
            SalesItemSummary itemSum = this.summaries.get(0);
            this.holdTime = itemSum.getSalesItem().getHoldTime();
        }
        if (this.holdTime != null) {
            return this.holdTime;
        }
        return 0;
    }

    public void setHeaders(List<? extends Object> value) {
        this.headers = value;
    }

    public List<? extends Object> getHeaders() {
        return this.headers;
    }

    public void setIdentifiers(List<? extends Object> value) {
        this.identifiers = value;
    }

    public List<? extends Object> getIdentifiers() {
        return this.identifiers;
    }

    public SalesQuantity getComboQuantity() {
        return this.comboQuantity;
    }

    public void setComboQuantity(SalesQuantity value) {
        this.comboQuantity = value;
    }

    public int getComboQuantityIndex() {
        return this.comboQuantityIndex;
    }

    public void setComboQuantityIndex(int value) {
        this.comboQuantityIndex = value;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<SalesQuantity> QUANTITY;
        public PropertiedObject.Property<SalesQuantity> COMBO_QUANTITY;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property<SalesItemSummary> SUMMARIES;
        public PropertiedObject.Property<Integer> COMBO_QUANTITY_INDEX;
        public PropertiedObject.Property<Integer> HOLD_TIME;
        public PropertiedObject.Property<String> STATE;
        public PropertiedObject.Property<Object> IDENTIFIERS;
        public PropertiedObject.Property<Object> HEADERS;
    }
}

