/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesItemSummaryCreator;
import ordermate.database.sales.SalesItemSummaryCreatorNew;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.printSummary.AbstractSummaryGroupingStrategy;
import ordermate.database.sales.printSummary.GroupByComboThenNameStrategy;
import ordermate.database.sales.printSummary.GroupByNameIgnoreComboStrategy;
import ordermate.database.sales.printSummary.GroupByNameStrategy;
import ordermate.database.sales.printSummary.NoGroupingStrategy;
import ordermate.database.sales.printSummary.PropertySummaryGroupingStrategy;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.database.sales.printSummary.SummaryGroupingStrategy;
import ordermate.database.sales.printSummary.sorting.SortingStrategyVendor;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;

public class SummaryGroupCreator {
    private static final Map<String, AbstractSummaryGroupingStrategy> register = new HashMap<String, AbstractSummaryGroupingStrategy>();
    private final SummaryGroupingStrategy grouping;
    private Boolean reprinted = Boolean.FALSE;
    private String systemState = "ACTIVE";
    private SummarySortingStrategy sorting;

    public static Collection getGroupingStrategies() {
        return register.values();
    }

    public static SummaryGroupingStrategy getStrategyByName(String name) {
        SummaryGroupingStrategy strategy = register.get(name);
        if (strategy == null) {
            OrderMate.LOG.error("Grouping strategy: '" + name + "' for printer: '" + name + "' not found.  No grouping strategy used", (Throwable)new Exception());
            return new NoGroupingStrategy();
        }
        return strategy;
    }

    public static SummaryGroupingStrategy getStrategy(VirtualPrinter printer) {
        DocketGrouping grouping = printer.getDocketGroupingPrep();
        if (grouping != null) {
            if (!register.containsKey(grouping.getID().toString())) {
                PropertySummaryGroupingStrategy strategy = PropertySummaryGroupingStrategy.createStrategyFrom(grouping);
                register.put(grouping.getID().toString(), strategy);
            }
            return register.get(grouping.getID().toString());
        }
        return register.get(printer.getPrepDocketGrouping());
    }

    public SummaryGroupCreator(VirtualPrinter printer) {
        this(SummaryGroupCreator.getStrategy(printer));
        this.sorting = SortingStrategyVendor.getSortingStrategy(printer.getDocketSortingPrep(), printer.getDocketSortingStrategy());
    }

    public SummaryGroupCreator(SummaryGroupingStrategy yourGrouping) {
        this.grouping = yourGrouping;
        this.sorting = SortingStrategyVendor.getDefaultSortingStrategy();
    }

    public SummaryGroupCreator reprinted(Boolean value) {
        this.reprinted = value;
        return this;
    }

    public SummaryGroupCreator systemState(String state) {
        this.systemState = state;
        return this;
    }

    public List<SalesItemSummaryGroup> createSummaryGroups(List<SalesItemSummary> summaries) {
        return this.grouping.group(summaries, this.systemState, this.reprinted);
    }

    public List<SalesItemSummaryGroup> createSummaryGroupsFromItems(List<? extends SalesLineItem> items) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        List<SalesItemSummary> summaries = null;
        summaries = this.grouping instanceof PropertySummaryGroupingStrategy ? new SalesItemSummaryCreatorNew((PropertySummaryGroupingStrategy)this.grouping, this.sorting).getSummaries(items) : (this.grouping instanceof GroupByNameIgnoreComboStrategy ? new SalesItemSummaryCreator(this.sorting).ignoreCombos().ignorePrice().getSummaries(items) : new SalesItemSummaryCreator(this.sorting).getSummaries(items));
        return this.createSummaryGroups(summaries);
    }

    static {
        register.put(VirtualPrinter.PrepDocketGrouping.ITEM_NAME.toString(), new GroupByNameStrategy());
        register.put(VirtualPrinter.PrepDocketGrouping.NONE.toString(), new NoGroupingStrategy());
        register.put(VirtualPrinter.PrepDocketGrouping.COMBO_ITEM_NAME.toString(), new GroupByComboThenNameStrategy());
        register.put(VirtualPrinter.PrepDocketGrouping.ITEM_NAME_IGNORE_COMBO.toString(), new GroupByNameIgnoreComboStrategy());
    }
}

