/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary.collecting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollection;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollectionStrategy;

public abstract class AbstractSalesItemSummaryCollectionStrategy<T>
implements SalesItemSummaryCollectionStrategy<T> {
    private List<SalesItemSummaryCollection<T>> collections;

    @Override
    public List<SalesItemSummaryCollection<T>> getCollections() {
        if (this.collections == null) {
            throw new IllegalStateException("Cannot call getCollections until makeCollections has been called");
        }
        return this.collections;
    }

    @Override
    public void makeCollections(Collection<SalesItemSummary> summaries) {
        HashMap<T, SalesItemSummaryCollection<T>> collectionMap = new HashMap<T, SalesItemSummaryCollection<T>>();
        for (SalesItemSummary summary : summaries) {
            T value = this.getCollectionObjectForSummary(summary);
            if (!collectionMap.containsKey(value)) {
                collectionMap.put(value, this.createCollectionFor(value));
            }
            ((SalesItemSummaryCollection)collectionMap.get(value)).addToCollection(summary);
        }
        this.collections = new ArrayList(collectionMap.values());
        this.sortCollections();
    }

    protected abstract SalesItemSummaryCollection<T> createCollectionFor(T var1);

    protected abstract T getCollectionObjectForSummary(SalesItemSummary var1);

    private void sortCollections() {
        Comparator<SalesItemSummaryCollection<T>> comparator = this.getComparator();
        if (comparator != null) {
            Collections.sort(this.collections, comparator);
        }
    }

    protected abstract Comparator<SalesItemSummaryCollection<T>> getComparator();
}

