/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary.collecting;

import au.com.ordermate.glazedlists.PropertyAccessorComparator;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessorVendor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ordermate.database.hardware.DocketGrouping;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.collecting.AbstractSalesItemSummaryCollectionStrategy;
import ordermate.database.sales.printSummary.collecting.DefaultSalesItemSummaryCollection;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollection;
import org.apache.commons.collections.keyvalue.MultiKey;

public class PropertySummaryCollectionStrategy
extends AbstractSalesItemSummaryCollectionStrategy<MultiKey> {
    private List<PropertyAccessor> groupingAccessor = new ArrayList<PropertyAccessor>();
    private Comparator comparator;

    public PropertySummaryCollectionStrategy(DocketGrouping yourGrouping) {
        PropertyAccessorVendor vendor = DocketGrouping.getVendor();
        this.addGroup(vendor.fromString(yourGrouping.getGroup1()));
        this.addGroup(vendor.fromString(yourGrouping.getGroup2()));
        this.addGroup(vendor.fromString(yourGrouping.getGroup3()));
        this.addGroup(vendor.fromString(yourGrouping.getGroup4()));
        this.addGroup(vendor.fromString(yourGrouping.getGroup5()));
        this.makeComparator();
    }

    private void makeComparator() {
        SequentialComparator newComparator = new SequentialComparator();
        for (PropertyAccessor accessor : this.groupingAccessor) {
            newComparator.addComparator(new SalesItemSummaryPropertyComparator(accessor));
        }
        this.comparator = newComparator;
    }

    private void addGroup(PropertyAccessor accessor) {
        if (accessor != null) {
            this.groupingAccessor.add(accessor);
        }
    }

    @Override
    protected SalesItemSummaryCollection createCollectionFor(MultiKey value) {
        DefaultSalesItemSummaryCollection collection = new DefaultSalesItemSummaryCollection(value);
        if (!this.groupingAccessor.isEmpty()) {
            collection.setDocketLabel(this.makeLabel(value));
        }
        return collection;
    }

    private String makeLabel(MultiKey value) {
        StringBuilder SB = new StringBuilder();
        Object[] keys = value.getKeys();
        for (int i = 0; i < this.groupingAccessor.size(); ++i) {
            if (keys[i] == null) continue;
            PropertyAccessor accessor = this.groupingAccessor.get(i);
            if (!accessor.getProperty().isReference()) {
                SB.append(accessor.getProperty().getUserVisibleLabel()).append(" ");
            }
            SB.append(keys[i]).append(" ");
        }
        return SB.toString();
    }

    @Override
    protected MultiKey getCollectionObjectForSummary(SalesItemSummary summary) {
        Object[] identifier = new Object[this.groupingAccessor.size()];
        for (int i = 0; i < identifier.length; ++i) {
            identifier[i] = this.groupingAccessor.get(i).resolveValue(summary.getSalesItem());
        }
        MultiKey key = new MultiKey(identifier);
        return key;
    }

    @Override
    protected Comparator getComparator() {
        return this.comparator;
    }

    class SalesItemSummaryPropertyComparator
    implements Comparator {
        private PropertyAccessorComparator comp;

        public SalesItemSummaryPropertyComparator(PropertyAccessor accessor) {
            this.comp = new PropertyAccessorComparator(accessor);
        }

        public int compare(Object o1, Object o2) {
            SalesItem s1 = ((DefaultSalesItemSummaryCollection)o1).getSummaries().get(0).getSalesItem();
            SalesItem s2 = ((DefaultSalesItemSummaryCollection)o2).getSummaries().get(0).getSalesItem();
            return this.comp.compare(s1, s2);
        }
    }
}

