/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary.sorting;

import java.util.List;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesOption;

public class SalesItemSorting {
    private static final int After = 1;
    private static final int Before = -1;
    private static final int Same = 0;

    public int compareBasedOnGroupSequence(SalesItem item1, SalesItem item2) {
        InventoryGroup group = item1.getLowestSequenceInventoryGroup();
        Integer groupSequence1 = group != null ? group.getSequence() : 0;
        group = item2.getLowestSequenceInventoryGroup();
        Integer groupSequence2 = group != null ? group.getSequence() : 0;
        if (groupSequence1 == 0) {
            groupSequence1 = null;
        }
        if (groupSequence2 == 0) {
            groupSequence2 = null;
        }
        if (groupSequence1 == null && groupSequence2 != null) {
            return -1;
        }
        if (groupSequence2 == null && groupSequence1 != null) {
            return 1;
        }
        if (groupSequence1 != null && groupSequence2 != null && !groupSequence1.equals(groupSequence2)) {
            return groupSequence1.compareTo(groupSequence2);
        }
        return 0;
    }

    public int compareBasedOnItem(SalesItem item1, SalesItem item2) {
        int returnValue = this.compareBasedOnItemSequence(item1, item2);
        if (returnValue == 0) {
            returnValue = this.compareBasedOnOptions(item1, item2);
        }
        return returnValue;
    }

    public int compareBasedOnItemSequence(SalesItem item1, SalesItem item2) {
        if (item1.getFirstInventoryItemSequence() != null && item2.getFirstInventoryItemSequence() != null && !item1.getFirstInventoryItemSequence().equals(item2.getFirstInventoryItemSequence())) {
            return item1.getFirstInventoryItemSequence().compareTo(item2.getFirstInventoryItemSequence());
        }
        if (item2.getFirstInventoryItemSequence() == null && item1.getFirstInventoryItemSequence() != null) {
            return 1;
        }
        if (item1.getFirstInventoryItemSequence() == null && item2.getFirstInventoryItemSequence() != null) {
            return -1;
        }
        if (item1.getID() != null && !item1.getID().equals(item2.getID())) {
            return item1.getID().compareTo(item2.getID());
        }
        return 0;
    }

    public int compareBasedOnOptions(SalesItem item1, SalesItem item2) {
        List<SalesComponent> components = item1.getComponentList();
        SalesComponent component1 = null;
        if (components.size() > 0) {
            component1 = components.get(0);
        }
        components = item2.getComponentList();
        SalesComponent component2 = null;
        if (components.size() > 0) {
            component2 = components.get(0);
        }
        if (component1 != null) {
            if (component2 != null) {
                if (component2.hasOption()) {
                    if (component1.hasOption()) {
                        SalesOption option1 = component1.getCurrentOptions().get(0);
                        SalesOption option2 = component2.getCurrentOptions().get(0);
                        Integer sequence1 = option1.getOption().getSequence();
                        Integer sequence2 = option2.getOption().getSequence();
                        return sequence1.compareTo(sequence2);
                    }
                    return -1;
                }
                if (component1.hasOption()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public int compareBasedOnName(SalesItem item1, SalesItem item2) {
        if (!item1.getLabel().equals(item2.getLabel())) {
            return item1.getLabel().compareTo(item2.getLabel());
        }
        return 0;
    }

    public int compareBasedOnSeats(SalesItem item1, SalesItem item2) {
        return Integer.valueOf(item1.getSeat()).compareTo(item2.getSeat());
    }

    public int compareBasedOnItemID(SalesItem item1, SalesItem item2) {
        if (item1.getID() == null) {
            if (item2.getID() == null) {
                return 0;
            }
            return -1;
        }
        if (item2.getID() == null) {
            return 1;
        }
        if (!item1.getID().equals(item2.getID())) {
            return item1.getID().compareTo(item2.getID());
        }
        return 0;
    }
}

