/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales.printSummary.sorting;

import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.printSummary.sorting.SummarySortingStrategy;

class SortByComboStrategyWrapper
implements SummarySortingStrategy {
    private SummarySortingStrategy delegateStrategy;

    public SortByComboStrategyWrapper(SummarySortingStrategy otherStrategy) {
        this.delegateStrategy = otherStrategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(SalesItem item1, SalesItem item2) {
        if (item1.isComboItem()) {
            if (!item2.isComboItem()) return 1;
            int retVal = this.compareCombos(item1.getParentCombo(), item2.getParentCombo());
            if (retVal == 0) return this.delegateStrategy.compare(item1, item2);
            return retVal;
        }
        if (!item2.isComboItem()) return this.delegateStrategy.compare(item1, item2);
        return -1;
    }

    private int compareCombos(SalesCombo combo1, SalesCombo combo2) {
        if (combo1.equals(combo2)) {
            return 0;
        }
        if (!combo1.getCombo().equals(combo2.getCombo())) {
            int toReturn = combo1.getCombo().getSequence() - combo2.getCombo().getSequence();
            if (toReturn != 0) {
                return toReturn;
            }
            return combo1.getCombo().getID().compareTo(combo2.getCombo().getID());
        }
        if (!combo1.isPersistent() || !combo2.isPersistent()) {
            int toReturn = Integer.valueOf(combo1.getAccountPosition()).compareTo(combo2.getAccountPosition());
            if (toReturn == 0) {
                toReturn = new Integer(combo1.hashCode()).compareTo(new Integer(combo2.hashCode()));
            }
            return toReturn;
        }
        return combo1.getID().compareTo(combo2.getID());
    }
}

